/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import org.gradle.api.internal.file.pattern.AnyWildcardPatternStep;
import org.gradle.api.internal.file.pattern.FixedPatternStep;
import org.gradle.api.internal.file.pattern.PatternStep;
import org.gradle.api.internal.file.pattern.RegExpPatternStep;
import org.gradle.api.internal.file.pattern.WildcardPrefixPatternStep;

public class PatternStepFactory {
    private static final AnyWildcardPatternStep ANY_WILDCARD_PATTERN_STEP = new AnyWildcardPatternStep();

    public static PatternStep getStep(String source, boolean caseSensitive) {
        if (source.length() == 0) {
            return new FixedPatternStep(source, caseSensitive);
        }
        char ch = source.charAt(0);
        if (ch == '*') {
            int pos;
            for (pos = 1; pos < source.length() && source.charAt(pos) == '*'; ++pos) {
            }
            if (pos == source.length()) {
                return ANY_WILDCARD_PATTERN_STEP;
            }
            for (int i = pos; i < source.length(); ++i) {
                ch = source.charAt(i);
                if (ch != '?' && ch != '*') continue;
                return new RegExpPatternStep(source, caseSensitive);
            }
            return new WildcardPrefixPatternStep(source.substring(pos), caseSensitive);
        }
        for (int i = 0; i < source.length(); ++i) {
            ch = source.charAt(i);
            if (ch != '?' && ch != '*') continue;
            return new RegExpPatternStep(source, caseSensitive);
        }
        return new FixedPatternStep(source, caseSensitive);
    }
}

