/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;

public class DifferenceFilter<T>
implements DefaultJDOMExternalizer.JDOMFilter {
    private final T myThisSettings;
    private final T myParentSettings;

    public DifferenceFilter(T object, T parentObject) {
        this.myThisSettings = object;
        this.myParentSettings = parentObject;
    }

    @Override
    public boolean isAccept(@NotNull Field field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/openapi/util/DifferenceFilter", "isAccept"));
        }
        try {
            Object thisValue = field.get(this.myThisSettings);
            Object parentValue = field.get(this.myParentSettings);
            return !Comparing.equal(thisValue, parentValue);
        }
        catch (Throwable e) {
            return true;
        }
    }
}

