/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io.win32;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.util.BitUtil;
import org.jetbrains.annotations.NotNull;

public class FileInfo {
    private static final int BROKEN_SYMLINK = -1;
    private static final int FILE_ATTRIBUTE_READONLY = 1;
    private static final int FILE_ATTRIBUTE_HIDDEN = 2;
    private static final int FILE_ATTRIBUTE_DIRECTORY = 16;
    private static final int FILE_ATTRIBUTE_DEVICE = 64;
    private static final int FILE_ATTRIBUTE_REPARSE_POINT = 1024;
    private String name;
    private int attributes;
    private long timestamp;
    private long length;

    public String getName() {
        return this.name;
    }

    @NotNull
    public FileAttributes toFileAttributes() {
        if (this.attributes == -1) {
            FileAttributes fileAttributes = FileAttributes.BROKEN_SYMLINK;
            if (fileAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/win32/FileInfo", "toFileAttributes"));
            }
            return fileAttributes;
        }
        boolean isDirectory = BitUtil.isSet(this.attributes, 16);
        boolean isSpecial = BitUtil.isSet(this.attributes, 64);
        boolean isSymlink = BitUtil.isSet(this.attributes, 1024);
        boolean isHidden = BitUtil.isSet(this.attributes, 2);
        boolean isWritable = !BitUtil.isSet(this.attributes, 1);
        long javaTimestamp = this.timestamp / 10000L - 11644473600000L;
        FileAttributes fileAttributes = new FileAttributes(isDirectory, isSpecial, isSymlink, isHidden, this.length, javaTimestamp, isDirectory || isWritable);
        if (fileAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/win32/FileInfo", "toFileAttributes"));
        }
        return fileAttributes;
    }

    public String toString() {
        return this.name;
    }
}

