/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.tools.idea.editors.gfxtrace.gapi.GapiPaths;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.gson.Gson;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class DeviceInfo {
    public final Package[] myPackages;

    public DeviceInfo(Package[] packages) {
        this.myPackages = packages;
    }

    public DeviceInfo transform(@NotNull Transform<Package> transform) {
        if (transform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transform", "com/android/tools/idea/editors/gfxtrace/DeviceInfo", "transform"));
        }
        ArrayList<Package> pkgs = new ArrayList<Package>();
        pkgs.ensureCapacity(this.myPackages.length);
        for (Package pkg : this.myPackages) {
            if ((pkg = transform.transform(pkg)) == null) continue;
            pkgs.add(pkg);
        }
        Collections.sort(pkgs);
        Package[] p = new Package[pkgs.size()];
        pkgs.toArray(p);
        return new DeviceInfo(p);
    }

    public static class PkgInfoProvider
    implements Provider {
        private static final int LATCH_TIMEOUT_MS = 3000;
        private static final int LOCAL_PORT = 3333;
        private static final String REMOTE_SOCKET = "pkginfo";
        private static final String PKGINFO_PACKAGE = "com.google.android.pkginfo";
        private static final String PKGINFO_SERVICE = "PkgInfoService";
        private static final String PKGINFO_ACTION = "com.google.android.pkginfo.action.SEND_PKG_INFO";
        private static final String ADB_COMMAND = "am startservice -n com.google.android.pkginfo/.PkgInfoService -a com.google.android.pkginfo.action.SEND_PKG_INFO";
        private static final int READ_SOCKET_MAX_RETRIES = 30;
        private static final int READ_SOCKET_DELAY_MS = 1000;
        @NotNull
        private static final Logger LOG = Logger.getInstance(PkgInfoProvider.class);
        public final IDevice myDevice;

        public PkgInfoProvider(IDevice device) {
            this.myDevice = device;
        }

        @Override
        public ListenableFuture<DeviceInfo> getDeviceInfo(int iconWidth, int iconHeight) {
            SettableFuture future = SettableFuture.create();
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)new FetchDeviceInfo(this.myDevice, (SettableFuture<DeviceInfo>)future, iconWidth, iconHeight));
            return future;
        }

        public static class ActivityInfo {
            public String Name;
            public boolean IsLaunch;
            public int Icon;

            public Activity get(Icon[] icons) {
                Icon icon = null;
                if (this.Icon >= 0) {
                    icon = icons[this.Icon];
                }
                return new Activity(this.Name, this.IsLaunch, icon);
            }
        }

        public static class PackageInfo {
            public String Name;
            public int Icon;
            public String ABI;
            public ActivityInfo[] Activities;

            public Package get(Icon[] icons) {
                Icon icon = null;
                if (this.Icon >= 0) {
                    icon = icons[this.Icon];
                }
                Activity[] activities = new Activity[this.Activities.length];
                for (int i = 0; i < this.Activities.length; ++i) {
                    activities[i] = this.Activities[i].get(icons);
                }
                return new Package(this.Name, icon, this.ABI, activities);
            }
        }

        public static class Info {
            public PackageInfo[] Packages;
            public String[] Icons;

            public DeviceInfo get(int iconWidth, int iconHeight) {
                Icon[] icons = new Icon[this.Icons.length];
                for (int i = 0; i < this.Icons.length; ++i) {
                    byte[] bytes = DatatypeConverter.parseBase64Binary((String)this.Icons[i]);
                    ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
                    try {
                        Image img = ImageIO.read(bin);
                        if (UIUtil.isRetina()) {
                            img = img.getScaledInstance(iconWidth * 2, iconHeight * 2, 4);
                            img = new JBHiDPIScaledImage(img, iconWidth, iconHeight, 2);
                        } else {
                            img = img.getScaledInstance(iconWidth, iconHeight, 1);
                        }
                        icons[i] = new JBImageIcon(img);
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                Package[] pkgs = new Package[this.Packages.length];
                for (int i = 0; i < this.Packages.length; ++i) {
                    pkgs[i] = this.Packages[i].get(icons);
                }
                return new DeviceInfo(pkgs);
            }
        }

        private static class FetchDeviceInfo
        implements Runnable {
            private final IDevice myDevice;
            private final SettableFuture<DeviceInfo> myFuture;
            private final int myIconWidth;
            private final int myIconHeight;

            public FetchDeviceInfo(IDevice device, SettableFuture<DeviceInfo> future, int iconWidth, int iconHeight) {
                this.myDevice = device;
                this.myFuture = future;
                this.myIconWidth = iconWidth;
                this.myIconHeight = iconHeight;
            }

            @Override
            public void run() {
                try {
                    this.installApk();
                    try {
                        this.myDevice.createForward(3333, PkgInfoProvider.REMOTE_SOCKET, IDevice.DeviceUnixSocketNamespace.ABSTRACT);
                        try {
                            this.myFuture.set((Object)this.requestAndReadResponse().get(this.myIconWidth, this.myIconHeight));
                        }
                        finally {
                            this.myDevice.removeForward(3333, PkgInfoProvider.REMOTE_SOCKET, IDevice.DeviceUnixSocketNamespace.ABSTRACT);
                        }
                    }
                    finally {
                        this.uninstallApk();
                    }
                }
                catch (Exception e) {
                    this.myFuture.setException((Throwable)e);
                }
            }

            private void installApk() throws Exception {
                File apk = GapiPaths.findPkgInfoApk();
                if (!apk.exists()) {
                    throw new RuntimeException("pkginfo.apk not found at " + apk.getAbsolutePath());
                }
                try {
                    this.myDevice.installPackage(apk.getAbsolutePath(), true, new String[0]);
                }
                catch (InstallException e) {
                    throw new RuntimeException("Failed to install pkginfo.apk: " + e.getMessage());
                }
            }

            private void uninstallApk() {
                try {
                    this.myDevice.uninstallPackage(PkgInfoProvider.PKGINFO_PACKAGE);
                }
                catch (InstallException e) {
                    LOG.warn("Failed to uninstall pkginfo: " + e.getMessage());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Info requestAndReadResponse() throws Exception {
                for (int i = 0; i < 30; ++i) {
                    Thread.sleep(1000L);
                    this.sendIntent();
                    try (Socket socket = new Socket("localhost", 3333);){
                        InputStream in = socket.getInputStream();
                        StringWriter out = new StringWriter();
                        IOUtils.copy((InputStream)in, (Writer)out);
                        String response = out.toString();
                        if (response.length() <= 0) continue;
                        Info info = (Info)new Gson().fromJson(response, Info.class);
                        return info;
                    }
                }
                throw new RuntimeException("Timeout waiting for package info");
            }

            private void sendIntent() throws Exception {
                CountDownLatch latch = new CountDownLatch(1);
                CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
                this.myDevice.executeShellCommand(PkgInfoProvider.ADB_COMMAND, (IShellOutputReceiver)receiver);
                latch.await(3000L, TimeUnit.MILLISECONDS);
            }
        }
    }

    public static class Activity
    implements Comparable<Activity> {
        public final String myName;
        public final boolean myIsLaunch;
        public final Icon myIcon;

        public Activity(String name, boolean isLaunch, Icon icon) {
            this.myName = name;
            this.myIsLaunch = isLaunch;
            this.myIcon = icon;
        }

        @Override
        public int compareTo(Activity other) {
            return this.myName.compareTo(other.myName);
        }
    }

    public static class Package
    implements Comparable<Package> {
        public final String myName;
        public final Icon myIcon;
        public final String myABI;
        public final Activity[] myActivities;

        public Package(String name, Icon icon, String abi, Activity[] activities) {
            this.myName = name;
            this.myIcon = icon;
            this.myABI = abi;
            this.myActivities = activities;
        }

        public Package transform(@NotNull Transform<Activity> filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/android/tools/idea/editors/gfxtrace/DeviceInfo$Package", "transform"));
            }
            ArrayList<Activity> activities = new ArrayList<Activity>();
            activities.ensureCapacity(this.myActivities.length);
            for (Activity act : this.myActivities) {
                if ((act = filter.transform(act)) == null) continue;
                activities.add(act);
            }
            Collections.sort(activities);
            Activity[] a = new Activity[activities.size()];
            activities.toArray(a);
            return new Package(this.myName, this.myIcon, this.myABI, a);
        }

        public Activity launchActivity() {
            for (Activity activity : this.myActivities) {
                if (!activity.myIsLaunch) continue;
                return activity;
            }
            return null;
        }

        @Override
        public int compareTo(Package other) {
            return this.myName.compareTo(other.myName);
        }
    }

    public static interface Transform<T> {
        public T transform(T var1);
    }

    public static interface Provider {
        public ListenableFuture<DeviceInfo> getDeviceInfo(int var1, int var2);
    }
}

