/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.renderers;

import com.android.tools.idea.editors.gfxtrace.controllers.AtomController;
import com.android.tools.idea.editors.gfxtrace.controllers.StateController;
import com.android.tools.idea.editors.gfxtrace.service.atom.DynamicAtom;
import com.android.tools.idea.editors.gfxtrace.service.memory.MemoryPointer;
import com.android.tools.idea.editors.gfxtrace.service.memory.MemoryRange;
import com.android.tools.rpclib.schema.AnyType;
import com.android.tools.rpclib.schema.Array;
import com.android.tools.rpclib.schema.Constant;
import com.android.tools.rpclib.schema.ConstantSet;
import com.android.tools.rpclib.schema.Dynamic;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.Interface;
import com.android.tools.rpclib.schema.Map;
import com.android.tools.rpclib.schema.Pointer;
import com.android.tools.rpclib.schema.Primitive;
import com.android.tools.rpclib.schema.Slice;
import com.android.tools.rpclib.schema.Struct;
import com.android.tools.rpclib.schema.Type;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;

public final class Render {
    @NotNull
    private static final Logger LOG = Logger.getInstance(Render.class);
    private static final int MAX_DISPLAY = 3;

    public static void render(@NotNull Object value, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (value instanceof Dynamic) {
            Render.render((Dynamic)value, component, attributes);
            return;
        }
        if (value instanceof Field) {
            Render.render((Field)value, component, attributes);
            return;
        }
        if (value instanceof StateController.Node) {
            Render.render((StateController.Node)value, component, attributes);
            return;
        }
        if (value instanceof StateController.Typed) {
            Render.render((StateController.Typed)value, component, attributes);
            return;
        }
        if (value instanceof AtomController.Node) {
            Render.render((AtomController.Node)value, component, attributes);
            return;
        }
        if (value instanceof AtomController.Memory) {
            Render.render((AtomController.Memory)value, component, attributes);
            return;
        }
        if (value instanceof AtomController.Group) {
            Render.render((AtomController.Group)value, component, attributes);
            return;
        }
        if (value instanceof DynamicAtom) {
            Render.render((DynamicAtom)value, component, attributes);
            return;
        }
        if (value instanceof MemoryPointer) {
            Render.render((MemoryPointer)value, component, attributes);
            return;
        }
        if (value instanceof MemoryRange) {
            Render.render((MemoryRange)value, component, attributes);
            return;
        }
        component.append(value.toString(), attributes);
    }

    public static void render(@NotNull Dynamic dynamic, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (dynamic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dynamic", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        component.append("{", SimpleTextAttributes.GRAY_ATTRIBUTES);
        for (int index = 0; index < dynamic.getFieldCount(); ++index) {
            if (index > 0) {
                component.append(",", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            Render.render(dynamic.getFieldValue(index), dynamic.getFieldInfo(index).getType(), component, attributes);
        }
        component.append("}", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    public static void render(@NotNull Field field, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        component.append(field.getName(), attributes);
    }

    public static void render(@NotNull StateController.Node node, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (node.key != null) {
            Render.render(node.key, component, attributes);
        }
        if (node.value != null) {
            component.append(": ", attributes);
            Render.render(node.value, component, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
        }
    }

    public static void render(@NotNull StateController.Typed typed, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (typed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typed", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        Render.render(typed.value, typed.type, component, attributes);
    }

    public static void render(@NotNull AtomController.Node node, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        Render.render(node.index, component, attributes);
        if (node.atom != null) {
            component.append(": ", attributes);
            Render.render(node.atom, component, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
        }
    }

    public static void render(@NotNull AtomController.Memory memory, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (memory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memory", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        Render.render(memory.isRead ? "read:" : "write:", component, attributes);
        Render.render(memory.observation.getRange(), component, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
    }

    public static void render(@NotNull AtomController.Group group, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        component.append(group.group.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
    }

    public static void render(@NotNull DynamicAtom atom, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (atom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atom", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        component.append(atom.getName() + "(", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        int resultIndex = atom.getResultIndex();
        int extrasIndex = atom.getExtrasIndex();
        boolean needComma = false;
        for (int i = 0; i < atom.getFieldCount(); ++i) {
            if (i == resultIndex || i == extrasIndex) continue;
            if (needComma) {
                component.append(", ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
            needComma = true;
            Field field = atom.getFieldInfo(i);
            Object parameterValue = atom.getFieldValue(i);
            Render.render(parameterValue, field.getType(), component, attributes);
        }
        component.append(")", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        if (resultIndex >= 0) {
            component.append("->", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            Field field = atom.getFieldInfo(resultIndex);
            Object parameterValue = atom.getFieldValue(resultIndex);
            Render.render(parameterValue, field.getType(), component, attributes);
        }
    }

    public static void render(@NotNull MemoryPointer pointer, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        component.append("0x" + Long.toHexString(pointer.getAddress()), attributes);
        if (pointer.getPool().value != 0) {
            component.append("@", SimpleTextAttributes.GRAY_ATTRIBUTES);
            component.append(pointer.getPool().toString(), attributes);
        }
    }

    public static void render(@NotNull MemoryRange range, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        component.append(Long.toString(range.getSize()), attributes);
        component.append(" bytes at ", SimpleTextAttributes.GRAY_ATTRIBUTES);
        component.append("0x" + Long.toHexString(range.getBase()), attributes);
    }

    public static void render(@NotNull Object value, @NotNull Type type, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type instanceof Primitive) {
            Render.render(value, (Primitive)type, component, attributes);
            return;
        }
        if (type instanceof Struct) {
            Render.render(value, (Struct)type, component, attributes);
            return;
        }
        if (type instanceof Pointer) {
            Render.render(value, (Pointer)type, component, attributes);
            return;
        }
        if (type instanceof Interface) {
            Render.render(value, (Interface)type, component, attributes);
            return;
        }
        if (type instanceof Array) {
            Render.render(value, (Array)type, component, attributes);
            return;
        }
        if (type instanceof Slice) {
            Render.render(value, (Slice)type, component, attributes);
            return;
        }
        if (type instanceof Map) {
            Render.render(value, (Map)type, component, attributes);
            return;
        }
        if (type instanceof AnyType) {
            Render.render(value, (AnyType)type, component, attributes);
            return;
        }
        Render.render(value, component, attributes);
    }

    public static void render(@NotNull Object value, @NotNull Struct type, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        Render.render(value, component, attributes);
    }

    public static void render(@NotNull Object value, @NotNull Pointer type, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        component.append("*", SimpleTextAttributes.GRAY_ATTRIBUTES);
        Render.render(value, component, attributes);
    }

    public static void render(@NotNull Object value, @NotNull Interface type, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        component.append("$", SimpleTextAttributes.GRAY_ATTRIBUTES);
        Render.render(value, component, attributes);
    }

    public static void render(@NotNull Object value, @NotNull Array type, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        assert (value instanceof Object[]);
        Render.render((Object[])value, type.getValueType(), component, attributes);
    }

    public static void render(@NotNull Object value, @NotNull Slice type, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        assert (value instanceof Object[]);
        Render.render((Object[])value, type.getValueType(), component, attributes);
    }

    public static void render(@NotNull Object value, @NotNull Map type, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        Render.render(value, component, attributes);
    }

    public static void render(@NotNull Object value, @NotNull AnyType type, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        Render.render(value, component, attributes);
    }

    public static void render(@NotNull Object value, @NotNull Primitive type, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        ConstantSet constants = ConstantSet.lookup((Type)type);
        if (constants != null) {
            for (Constant constant : constants.getEntries()) {
                if (!value.equals(constant.getValue())) continue;
                component.append(constant.getName(), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                return;
            }
        }
        switch (type.getMethod().value) {
            case 0: {
                component.append(String.format("%b", (Boolean)value), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                return;
            }
            case 1: {
                component.append(String.format("%d", (Byte)value), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                return;
            }
            case 2: {
                component.append(String.format("%d", ((Byte)value).intValue() & 0xFF), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                return;
            }
            case 3: {
                component.append(String.format("%d", (Short)value), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                return;
            }
            case 4: {
                component.append(String.format("%d", ((Short)value).intValue() & 0xFFFF), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                return;
            }
            case 5: {
                component.append(String.format("%d", (Integer)value), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                return;
            }
            case 6: {
                component.append(String.format("%d", ((Integer)value).longValue() & 0xFFFFFFFFL), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                return;
            }
            case 7: {
                component.append(String.format("%d", (Long)value), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                return;
            }
            case 8: {
                component.append(String.format("0x%s", Long.toHexString((Long)value)), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                return;
            }
            case 9: {
                component.append(String.format("%f", (Float)value), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                return;
            }
            case 10: {
                component.append(String.format("%f", (Double)value), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                return;
            }
            case 11: {
                component.append((String)value, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
                return;
            }
        }
        component.append(value.toString(), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
    }

    public static void render(@NotNull Object[] array, @NotNull Type valueType, @NotNull SimpleColoredComponent component, SimpleTextAttributes attributes) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (valueType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueType", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/gfxtrace/renderers/Render", "render"));
        }
        int count = Math.min(array.length, 3);
        component.append("[", SimpleTextAttributes.GRAY_ATTRIBUTES);
        for (int index = 0; index < count; ++index) {
            if (index > 0) {
                component.append(",", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            Render.render(array[index], valueType, component, attributes);
        }
        if (count < array.length) {
            component.append("...", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }
}

