/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.FontUtil;
import com.android.tools.idea.editors.strings.table.ConstantColumn;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.StringsCellRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.AbstractTableCellEditor;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class StringsCellEditor
extends AbstractTableCellEditor {
    private final JBTextField myTextField = new JBTextField();

    public StringsCellEditor() {
        this.myTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    StringsCellEditor.this.stopCellEditing();
                    e.consume();
                } else {
                    super.keyPressed(e);
                }
            }
        });
    }

    public boolean isCellEditable(EventObject e) {
        boolean returnKeyPressed;
        boolean doubleClick = e instanceof MouseEvent && ((MouseEvent)e).getClickCount() == 2 && ((MouseEvent)e).getButton() == 1;
        boolean bl = returnKeyPressed = e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 10;
        if (!doubleClick && !returnKeyPressed) {
            return false;
        }
        if (!(e.getSource() instanceof JTable)) {
            return false;
        }
        JTable source = (JTable)e.getSource();
        if (source.getSelectedRowCount() != 1 || source.getSelectedColumnCount() != 1) {
            return false;
        }
        int row = source.convertRowIndexToModel(source.getSelectedRow());
        int col = source.convertColumnIndexToModel(source.getSelectedColumn());
        if (col == ConstantColumn.KEY.ordinal()) {
            return false;
        }
        StringResourceTableModel model = (StringResourceTableModel)source.getModel();
        String value = (String)model.getValueAt(row, col);
        return !StringsCellRenderer.shouldClip(value);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        StringResourceTableModel model = (StringResourceTableModel)table.getModel();
        row = table.convertRowIndexToModel(row);
        column = table.convertColumnIndexToModel(column);
        String v = (String)model.getValueAt(row, column);
        this.myTextField.setText(v);
        this.myTextField.setFont(FontUtil.getFontAbleToDisplay(v, this.myTextField.getFont()));
        return this.myTextField;
    }

    public Object getCellEditorValue() {
        return this.myTextField.getText();
    }

    @VisibleForTesting
    public void setCellEditorValue(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/strings/table/StringsCellEditor", "setCellEditorValue"));
        }
        this.myTextField.setText((String)value);
    }
}

