/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.ui;

import com.google.common.collect.Lists;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import icons.AndroidIcons;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;
import org.jetbrains.annotations.NotNull;

public class VariantsComboBox
extends JButton
implements ItemSelectable {
    private static final Border VARIANT_MENU_BORDER = JBUI.Borders.empty((int)5, (int)0);
    private static final Border VARIANT_ITEM_BORDER = new JBEmptyBorder(5);
    private static final JBColor VARIANT_MENU_BACKGROUND_COLOR = JBColor.WHITE;
    private final List<PopupClosingListener> myPopupClosingListeners = new ArrayList<PopupClosingListener>();
    private ComboBoxModel myModel = new DefaultComboBoxModel();
    private final ListDataListener myListDataListener = new ListDataListener(){

        @Override
        public void intervalAdded(ListDataEvent e) {
            VariantsComboBox.this.fireModelUpdated();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            VariantsComboBox.this.fireModelUpdated();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            VariantsComboBox.this.fireModelUpdated();
        }
    };
    private final List<Action> myActions = Lists.newArrayList();

    public void addPopupClosingListener(PopupClosingListener listener) {
        this.myPopupClosingListeners.add(listener);
    }

    public VariantsComboBox() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setIcon(AndroidIcons.GreyArrowDown);
        Font font = this.getFont();
        this.setFont(font.deriveFont((float)font.getSize() * 0.9f));
        this.setHorizontalTextPosition(2);
        this.setHorizontalAlignment(4);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!VariantsComboBox.this.isShowing()) {
                    return;
                }
                if (!VariantsComboBox.this.isPopupEnabled()) {
                    return;
                }
                final AWTEventListener clickListener = new AWTEventListener(){

                    @Override
                    public void eventDispatched(AWTEvent event) {
                        MouseEvent mouseEvent = (MouseEvent)event;
                        if (mouseEvent.getID() == 501 && VariantsComboBox.this.contains(mouseEvent.getPoint())) {
                            mouseEvent.consume();
                        }
                    }
                };
                JPopupMenu variantsMenu = VariantsComboBox.this.createPopupMenu();
                variantsMenu.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        Toolkit.getDefaultToolkit().addAWTEventListener(clickListener, 16L);
                    }

                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        Toolkit.getDefaultToolkit().removeAWTEventListener(clickListener);
                        for (PopupClosingListener listener : VariantsComboBox.this.myPopupClosingListeners) {
                            listener.popupClosed();
                        }
                    }
                });
                variantsMenu.show(VariantsComboBox.this, 0, VariantsComboBox.this.getSize().height);
            }
        });
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setModel(@NotNull ComboBoxModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/editors/theme/ui/VariantsComboBox", "setModel"));
        }
        this.myModel.removeListDataListener(this.myListDataListener);
        this.myModel = model;
        this.myModel.addListDataListener(this.myListDataListener);
        this.fireModelUpdated();
    }

    @Override
    public void updateUI() {
        this.setUI((ButtonUI)BasicButtonUI.createUI(this));
    }

    @NotNull
    protected JPopupMenu createPopupMenu() {
        Font font;
        JBPopupMenu menu = new JBPopupMenu();
        Border existingBorder = menu.getBorder();
        if (existingBorder != null) {
            menu.setBorder(BorderFactory.createCompoundBorder(existingBorder, VARIANT_MENU_BORDER));
        } else {
            menu.setBorder(VARIANT_MENU_BORDER);
        }
        menu.setBackground((Color)VARIANT_MENU_BACKGROUND_COLOR);
        int nElements = this.myModel.getSize();
        for (int i = 0; i < nElements; ++i) {
            final Object element = this.myModel.getElementAt(i);
            JBMenuItem item = new JBMenuItem(element.toString());
            font = item.getFont();
            item.setFont(font.deriveFont((float)font.getSize() * 0.9f));
            item.setBorder(VARIANT_ITEM_BORDER);
            if (i == 0) {
                item.setArmed(true);
            }
            item.setBackground((Color)VARIANT_MENU_BACKGROUND_COLOR);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object selectedItem = VariantsComboBox.this.myModel.getSelectedItem();
                    if (selectedItem != null) {
                        VariantsComboBox.this.fireItemSelectionChanged(new ItemEvent(VariantsComboBox.this, 701, selectedItem, 2));
                    }
                    VariantsComboBox.this.myModel.setSelectedItem(element);
                    VariantsComboBox.this.fireModelUpdated();
                    VariantsComboBox.this.fireItemSelectionChanged(new ItemEvent(VariantsComboBox.this, 701, element, 1));
                }
            });
            menu.add((JMenuItem)item);
        }
        if (!this.myActions.isEmpty()) {
            if (nElements > 0) {
                menu.addSeparator();
            }
            for (Action action : this.myActions) {
                JBMenuItem newMenuItem = new JBMenuItem(action);
                font = newMenuItem.getFont();
                newMenuItem.setFont(font.deriveFont((float)font.getSize() * 0.9f));
                newMenuItem.setBackground((Color)VARIANT_MENU_BACKGROUND_COLOR);
                newMenuItem.setBorder(VARIANT_ITEM_BORDER);
                menu.add((JMenuItem)newMenuItem);
            }
        }
        JBPopupMenu jBPopupMenu = menu;
        if (jBPopupMenu == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ui/VariantsComboBox", "createPopupMenu"));
        }
        return jBPopupMenu;
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] objectArray;
        Object selectedObject = this.myModel.getSelectedItem();
        if (selectedObject != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = selectedObject;
        } else {
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return objectArray;
    }

    @Override
    public void addItemListener(@NotNull ItemListener itemListener) {
        if (itemListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemListener", "com/android/tools/idea/editors/theme/ui/VariantsComboBox", "addItemListener"));
        }
        this.listenerList.add(ItemListener.class, itemListener);
    }

    @Override
    public void removeItemListener(@NotNull ItemListener itemListener) {
        if (itemListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemListener", "com/android/tools/idea/editors/theme/ui/VariantsComboBox", "removeItemListener"));
        }
        this.listenerList.remove(ItemListener.class, itemListener);
    }

    @Override
    @NotNull
    public ItemListener[] getItemListeners() {
        ItemListener[] itemListenerArray = (ItemListener[])this.listenerList.getListeners(ItemListener.class);
        if (itemListenerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ui/VariantsComboBox", "getItemListeners"));
        }
        return itemListenerArray;
    }

    protected void fireModelUpdated() {
        this.setText(this.myModel.getSelectedItem().toString());
        this.setIcon(this.isPopupEnabled() ? AndroidIcons.GreyArrowDown : null);
    }

    protected void fireItemSelectionChanged(@NotNull ItemEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/editors/theme/ui/VariantsComboBox", "fireItemSelectionChanged"));
        }
        for (ItemListener itemListener : this.getItemListeners()) {
            itemListener.itemStateChanged(e);
        }
    }

    protected boolean isPopupEnabled() {
        return this.myModel.getSize() > 1 || !this.myActions.isEmpty();
    }

    public void addAction(@NotNull Action action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/editors/theme/ui/VariantsComboBox", "addAction"));
        }
        this.myActions.add(action);
    }

    public static interface PopupClosingListener {
        public void popupClosed();
    }
}

