/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.entity;

import com.android.tools.idea.gradle.editor.entity.AbstractGradleEditorEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorSourceBinding;
import com.android.tools.idea.gradle.editor.entity.GradleEntityDeclarationValueLocationAware;
import com.android.tools.idea.gradle.editor.entity.GradleEntityDefinitionValueLocationAware;
import com.android.tools.idea.gradle.editor.metadata.GradleEditorEntityMetaData;
import com.android.tools.idea.gradle.editor.value.GradleEditorEntityValueManager;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDependencyGradleEditorEntity
extends AbstractGradleEditorEntity
implements GradleEntityDeclarationValueLocationAware,
GradleEntityDefinitionValueLocationAware {
    @NotNull
    private String myScope;
    @NotNull
    private final List<GradleEditorSourceBinding> myScopeBindings;
    @NotNull
    private String myGroupId;
    @NotNull
    private final List<GradleEditorSourceBinding> myGroupIdSourceBindings;
    @NotNull
    private String myArtifactId;
    @NotNull
    private final List<GradleEditorSourceBinding> myArtifactIdSourceBindings;
    @NotNull
    private String myVersion;
    @NotNull
    private final List<GradleEditorSourceBinding> myVersionSourceBindings;
    @NotNull
    private final GradleEditorSourceBinding myVersionDeclarationLocation;
    @NotNull
    private final GradleEditorEntityValueManager myVersionValueManager;

    public ExternalDependencyGradleEditorEntity(@NotNull String scope, @NotNull List<GradleEditorSourceBinding> scopeSourceBindings, @NotNull String groupId, @NotNull List<GradleEditorSourceBinding> groupIdSourceBindings, @NotNull String artifactId, @NotNull List<GradleEditorSourceBinding> artifactIdSourceBindings, @NotNull String version, @NotNull List<GradleEditorSourceBinding> versionSourceBindings, @NotNull GradleEditorSourceBinding entityLocation, @NotNull GradleEditorSourceBinding versionDeclarationLocation, @NotNull GradleEditorEntityValueManager versionValueManager, @NotNull Set<GradleEditorEntityMetaData> metaData) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "<init>"));
        }
        if (scopeSourceBindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeSourceBindings", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "<init>"));
        }
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "<init>"));
        }
        if (groupIdSourceBindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupIdSourceBindings", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "<init>"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "<init>"));
        }
        if (artifactIdSourceBindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactIdSourceBindings", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "<init>"));
        }
        if (versionSourceBindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionSourceBindings", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "<init>"));
        }
        if (entityLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entityLocation", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "<init>"));
        }
        if (versionDeclarationLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionDeclarationLocation", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "<init>"));
        }
        if (versionValueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionValueManager", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "<init>"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "<init>"));
        }
        super(entityLocation, metaData, null);
        this.myScopeBindings = Lists.newArrayList();
        this.myGroupIdSourceBindings = Lists.newArrayList();
        this.myArtifactIdSourceBindings = Lists.newArrayList();
        this.myVersionSourceBindings = Lists.newArrayList();
        this.myScope = scope;
        this.myScopeBindings.addAll(scopeSourceBindings);
        this.myGroupId = groupId;
        this.myGroupIdSourceBindings.addAll(groupIdSourceBindings);
        this.myArtifactId = artifactId;
        this.myArtifactIdSourceBindings.addAll(artifactIdSourceBindings);
        this.myVersion = version;
        this.myVersionSourceBindings.addAll(versionSourceBindings);
        this.myVersionDeclarationLocation = versionDeclarationLocation;
        this.myVersionValueManager = versionValueManager;
    }

    @Override
    @NotNull
    public String getName() {
        String string = String.format("%s %s:%s:%s", this.myScope, this.myGroupId, this.myArtifactId, this.myVersion);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "getName"));
        }
        return string;
    }

    @NotNull
    public String getScope() {
        String string = this.myScope;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "getScope"));
        }
        return string;
    }

    @NotNull
    public List<GradleEditorSourceBinding> getScopeBindings() {
        List<GradleEditorSourceBinding> list = this.myScopeBindings;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "getScopeBindings"));
        }
        return list;
    }

    @NotNull
    public String getGroupId() {
        String string = this.myGroupId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "getGroupId"));
        }
        return string;
    }

    @NotNull
    public List<GradleEditorSourceBinding> getGroupIdSourceBindings() {
        List<GradleEditorSourceBinding> list = this.myGroupIdSourceBindings;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "getGroupIdSourceBindings"));
        }
        return list;
    }

    @NotNull
    public String getArtifactId() {
        String string = this.myArtifactId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "getArtifactId"));
        }
        return string;
    }

    @NotNull
    public List<GradleEditorSourceBinding> getArtifactIdSourceBindings() {
        List<GradleEditorSourceBinding> list = this.myArtifactIdSourceBindings;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "getArtifactIdSourceBindings"));
        }
        return list;
    }

    @NotNull
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "getVersion"));
        }
        return string;
    }

    @NotNull
    public List<GradleEditorSourceBinding> getVersionSourceBindings() {
        List<GradleEditorSourceBinding> list = this.myVersionSourceBindings;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "getVersionSourceBindings"));
        }
        return list;
    }

    @Override
    @NotNull
    public GradleEditorSourceBinding getDeclarationValueLocation() {
        GradleEditorSourceBinding gradleEditorSourceBinding = this.myVersionDeclarationLocation;
        if (gradleEditorSourceBinding == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "getDeclarationValueLocation"));
        }
        return gradleEditorSourceBinding;
    }

    @Override
    @Nullable
    public GradleEditorSourceBinding getDefinitionValueLocation() {
        return this.myVersionSourceBindings.size() == 1 ? this.myVersionSourceBindings.get(0) : null;
    }

    @NotNull
    public GradleEditorEntityValueManager getVersionValueManager() {
        GradleEditorEntityValueManager gradleEditorEntityValueManager = this.myVersionValueManager;
        if (gradleEditorEntityValueManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "getVersionValueManager"));
        }
        return gradleEditorEntityValueManager;
    }

    @Nullable
    public String changeVersion(@NotNull String newVersion) {
        if (newVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newVersion", "com/android/tools/idea/gradle/editor/entity/ExternalDependencyGradleEditorEntity", "changeVersion"));
        }
        if (newVersion.equals(this.getVersion())) {
            return null;
        }
        List<GradleEditorSourceBinding> sourceBindings = this.getVersionSourceBindings();
        if (sourceBindings.size() != 1) {
            return String.format("Can't apply version '%s' to the entity '%s'. Reason: expected the entity to hold only one version source binding but it has %d (%s)", newVersion, this, sourceBindings.size(), sourceBindings);
        }
        GradleEditorSourceBinding binding = sourceBindings.get(0);
        RangeMarker rangeMarker = binding.getRangeMarker();
        if (!rangeMarker.isValid()) {
            return String.format("Can't apply version '%s' to the entity '%s'. Reason: source file binding is incorrect", newVersion, this);
        }
        this.myVersion = newVersion;
        rangeMarker.getDocument().replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)newVersion);
        return null;
    }

    @Override
    public void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myVersionDeclarationLocation);
        for (GradleEditorSourceBinding binding : this.myScopeBindings) {
            Disposer.dispose((Disposable)binding);
        }
        for (GradleEditorSourceBinding binding : this.myGroupIdSourceBindings) {
            Disposer.dispose((Disposable)binding);
        }
        for (GradleEditorSourceBinding binding : this.myArtifactIdSourceBindings) {
            Disposer.dispose((Disposable)binding);
        }
        for (GradleEditorSourceBinding binding : this.myVersionSourceBindings) {
            Disposer.dispose((Disposable)binding);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (!this.getMetaData().isEmpty()) {
            buffer.append('[').append(Joiner.on((char)'|').join(this.getMetaData())).append("] ");
        }
        buffer.append(this.myScope.isEmpty() ? String.format("<defined %d times>", this.myScopeBindings.size()) : this.myScope);
        buffer.append(" ").append(this.myGroupId.isEmpty() ? String.format("<defined %d times>", this.myGroupIdSourceBindings.size()) : this.myGroupId);
        buffer.append(":").append(this.myArtifactId.isEmpty() ? String.format("<defined %d times>", this.myArtifactIdSourceBindings.size()) : this.myArtifactId);
        buffer.append(":").append(this.myVersion.isEmpty() ? String.format("<defined %d times>", this.myVersionSourceBindings.size()) : this.myVersion);
        return buffer.toString();
    }
}

