/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.entity;

import com.android.tools.idea.gradle.editor.entity.GradleEditorEntity;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GradleEditorEntityGroup
implements Disposable {
    @NotNull
    private final String myName;
    @NotNull
    private final List<GradleEditorEntity> myEntities;
    @NotNull
    private final List<GradleEditorEntity> myEntitiesView;

    public GradleEditorEntityGroup(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/editor/entity/GradleEditorEntityGroup", "<init>"));
        }
        this(name, Collections.emptyList());
    }

    public GradleEditorEntityGroup(@NotNull String name, @NotNull Iterable<GradleEditorEntity> entities) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/editor/entity/GradleEditorEntityGroup", "<init>"));
        }
        if (entities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entities", "com/android/tools/idea/gradle/editor/entity/GradleEditorEntityGroup", "<init>"));
        }
        this.myName = name;
        this.myEntities = Lists.newArrayList(entities);
        this.myEntitiesView = Collections.unmodifiableList(this.myEntities);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/GradleEditorEntityGroup", "getName"));
        }
        return string;
    }

    @NotNull
    public List<GradleEditorEntity> getEntities() {
        List<GradleEditorEntity> list = this.myEntitiesView;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/GradleEditorEntityGroup", "getEntities"));
        }
        return list;
    }

    public void addEntity(@NotNull GradleEditorEntity entity) {
        if (entity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entity", "com/android/tools/idea/gradle/editor/entity/GradleEditorEntityGroup", "addEntity"));
        }
        this.myEntities.add(entity);
    }

    public void dispose() {
        for (GradleEditorEntity entity : this.myEntities) {
            Disposer.dispose((Disposable)entity);
        }
    }

    public String toString() {
        return String.format("%s [%d entities]", this.myName, this.myEntities.size());
    }
}

