/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.ui;

import com.android.tools.idea.gradle.editor.entity.ExternalDependencyGradleEditorEntity;
import com.android.tools.idea.gradle.editor.ui.GradleEditorComboBox;
import com.android.tools.idea.gradle.editor.ui.GradleEditorEntityUi;
import com.android.tools.idea.gradle.editor.ui.GradleEditorUiConstants;
import com.android.tools.idea.gradle.editor.ui.ReferencedValuesGradleEditorComponent;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=100)
public class ExternalDependencyEntityUi
implements GradleEditorEntityUi<ExternalDependencyGradleEditorEntity> {
    private final MyComponent myRenderer = new MyComponent();
    private final MyComponent myEditor = new MyComponent();
    private final MyComponent mySizeComponent = new MyComponent();

    @Override
    @NotNull
    public Class<ExternalDependencyGradleEditorEntity> getTargetEntityClass() {
        if (ExternalDependencyGradleEditorEntity.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/ui/ExternalDependencyEntityUi", "getTargetEntityClass"));
        }
        return ExternalDependencyGradleEditorEntity.class;
    }

    @Override
    @NotNull
    public JComponent getComponent(@Nullable JComponent component, @NotNull JTable table, @NotNull ExternalDependencyGradleEditorEntity entity, @NotNull Project project, boolean editing, boolean isSelected, boolean hasFocus, boolean sizeOnly, int row, int column) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/android/tools/idea/gradle/editor/ui/ExternalDependencyEntityUi", "getComponent"));
        }
        if (entity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entity", "com/android/tools/idea/gradle/editor/ui/ExternalDependencyEntityUi", "getComponent"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/editor/ui/ExternalDependencyEntityUi", "getComponent"));
        }
        if (component != null) {
            JComponent jComponent = component;
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/ui/ExternalDependencyEntityUi", "getComponent"));
            }
            return jComponent;
        }
        MyComponent c = sizeOnly ? this.mySizeComponent : (editing ? this.myEditor : this.myRenderer);
        c.bind(entity, project, table, editing);
        MyComponent myComponent = c;
        if (myComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/ui/ExternalDependencyEntityUi", "getComponent"));
        }
        return myComponent;
    }

    @Override
    @Nullable
    public String flush(@NotNull ExternalDependencyGradleEditorEntity entity) {
        if (entity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entity", "com/android/tools/idea/gradle/editor/ui/ExternalDependencyEntityUi", "flush"));
        }
        if (!this.myEditor.editorVersion.isVisible()) {
            return null;
        }
        Object item = this.myEditor.editorVersion.getEditor().getItem();
        if (item != null) {
            return entity.changeVersion(item.toString());
        }
        return null;
    }

    private static class MyComponent
    extends JBPanel {
        private final JLabel mySimpleScope = new JLabel();
        private final ReferencedValuesGradleEditorComponent myRefScope = new ReferencedValuesGradleEditorComponent();
        private final JLabel mySimpleGroup = new JLabel();
        private final ReferencedValuesGradleEditorComponent myRefGroup = new ReferencedValuesGradleEditorComponent();
        private final JLabel mySimpleArtifact = new JLabel();
        private final ReferencedValuesGradleEditorComponent myRefArtifact = new ReferencedValuesGradleEditorComponent();
        private final JLabel mySimpleVersion = new JLabel();
        private final ReferencedValuesGradleEditorComponent myRefVersion = new ReferencedValuesGradleEditorComponent();
        private final DefaultComboBoxModel myEditorVersionModel = new DefaultComboBoxModel();
        final GradleEditorComboBox editorVersion = new GradleEditorComboBox(this.myEditorVersionModel);

        MyComponent() {
            super((LayoutManager)new GridBagLayout());
            this.setBackground(GradleEditorUiConstants.BACKGROUND_COLOR);
            this.editorVersion.setBackground(GradleEditorUiConstants.BACKGROUND_COLOR);
            this.editorVersion.setEditable(true);
            GridBag constraints = new GridBag().anchor(17);
            this.add(this.mySimpleScope, constraints);
            this.add((Component)((Object)this.myRefScope), constraints);
            this.add((Component)new JBLabel(" "), constraints);
            this.add(this.mySimpleGroup, constraints);
            this.add((Component)((Object)this.myRefGroup), constraints);
            this.add((Component)new JBLabel(":"), constraints);
            this.add(this.mySimpleArtifact, constraints);
            this.add((Component)((Object)this.myRefArtifact), constraints);
            this.add((Component)new JBLabel(":"), constraints);
            this.add(this.mySimpleVersion, constraints);
            this.add((Component)((Object)this.myRefVersion), constraints);
            this.add((Component)((Object)this.editorVersion), constraints);
        }

        public void bind(@NotNull ExternalDependencyGradleEditorEntity entity, @NotNull Project project, @NotNull JTable table, boolean editing) {
            if (entity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entity", "com/android/tools/idea/gradle/editor/ui/ExternalDependencyEntityUi$MyComponent", "bind"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/editor/ui/ExternalDependencyEntityUi$MyComponent", "bind"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/android/tools/idea/gradle/editor/ui/ExternalDependencyEntityUi$MyComponent", "bind"));
            }
            boolean refScope = entity.getScope().isEmpty();
            this.mySimpleScope.setVisible(!refScope);
            this.myRefScope.setVisible(refScope);
            this.mySimpleScope.setText(entity.getScope());
            this.myRefScope.bind(project, entity.getScopeBindings());
            boolean refGroup = entity.getGroupId().isEmpty();
            this.mySimpleGroup.setVisible(!refGroup);
            this.myRefGroup.setVisible(refGroup);
            this.mySimpleGroup.setText(entity.getGroupId());
            this.myRefGroup.bind(project, entity.getGroupIdSourceBindings());
            boolean refArtifact = entity.getArtifactId().isEmpty();
            this.mySimpleArtifact.setVisible(!refArtifact);
            this.myRefArtifact.setVisible(refArtifact);
            this.mySimpleArtifact.setText(entity.getArtifactId());
            this.myRefArtifact.bind(project, entity.getArtifactIdSourceBindings());
            boolean refVersion = entity.getVersion().isEmpty();
            this.mySimpleVersion.setVisible(!editing && !refVersion);
            this.myRefVersion.setVisible(refVersion);
            this.editorVersion.setVisible(editing && !refVersion);
            this.editorVersion.setTable(table);
            this.mySimpleVersion.setText(entity.getVersion());
            this.myRefVersion.bind(project, entity.getVersionSourceBindings());
            if (editing && !refVersion) {
                this.myEditorVersionModel.removeAllElements();
                this.myEditorVersionModel.addElement(entity.getVersion());
                entity.getVersionValueManager().hintAvailableVersions();
            }
        }
    }
}

