/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Joiner;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GradleBuildFileUpdater
extends ModuleAdapter
implements BulkFileListener {
    private final Project myProject;

    public GradleBuildFileUpdater(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "<init>"));
        }
        this.myProject = project;
    }

    public void moduleAdded(@NotNull Project project, final @NotNull Module module) {
        PsiFile psiFile;
        Module found;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "moduleAdded"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "moduleAdded"));
        }
        if (GradleSyncState.getInstance(project).isSyncInProgress()) {
            return;
        }
        final GradleSettingsFile settingsFile = GradleSettingsFile.get(project);
        if (settingsFile != null && (found = ModuleUtilCore.findModuleForPsiElement((PsiElement)(psiFile = settingsFile.getPsiFile()))) != null) {
            new WriteCommandAction<Void>(project, "Update settings.gradle", new PsiFile[]{psiFile}){

                protected void run(@NotNull Result<Void> result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater$1", "run"));
                    }
                    settingsFile.addModule(module);
                }
            }.execute();
        }
    }

    public void moduleRemoved(@NotNull Project project, final @NotNull Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "moduleRemoved"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "moduleRemoved"));
        }
        if (GradleSyncState.getInstance(project).isSyncInProgress()) {
            return;
        }
        final GradleSettingsFile settingsFile = GradleSettingsFile.get(project);
        if (settingsFile != null) {
            new WriteCommandAction<Void>(project, "Update settings.gradle", new PsiFile[]{settingsFile.getPsiFile()}){

                protected void run(@NotNull Result<Void> result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater$2", "run"));
                    }
                    settingsFile.removeModule(module);
                }
            }.execute();
        }
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "before"));
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "after"));
        }
        for (VFileEvent vFileEvent : events) {
            GradleSettingsFile settingsFile;
            String newPath;
            String oldPath;
            AndroidGradleFacet androidGradleFacet;
            Module[] modules;
            VirtualFile eventFile;
            VFilePropertyChangeEvent propChangeEvent;
            if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals((propChangeEvent = (VFilePropertyChangeEvent)vFileEvent).getPropertyName()) || !(eventFile = propChangeEvent.getFile()).isDirectory()) continue;
            Module module = null;
            for (Module m : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
                VirtualFile moduleDir;
                VirtualFile file = GradleUtil.getGradleBuildFile(m);
                if (file == null || (moduleDir = file.getParent()) == null || !FileUtil.pathsEqual((String)eventFile.getPath(), (String)moduleDir.getPath())) continue;
                module = m;
                break;
            }
            if (module == null || (androidGradleFacet = AndroidGradleFacet.getInstance(module)) == null || (oldPath = ((AndroidGradleFacetConfiguration)androidGradleFacet.getConfiguration()).GRADLE_PROJECT_PATH).equals(newPath = GradleBuildFileUpdater.updateProjectNameInGradlePath(androidGradleFacet, eventFile)) || (settingsFile = GradleSettingsFile.get(this.myProject)) == null) continue;
            settingsFile.removeModule(oldPath);
            settingsFile.addModule(newPath, VfsUtilCore.virtualToIoFile((VirtualFile)eventFile));
        }
    }

    @NotNull
    private static String updateProjectNameInGradlePath(@NotNull AndroidGradleFacet androidGradleFacet, @NotNull VirtualFile moduleDir) {
        String newPath;
        if (androidGradleFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidGradleFacet", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "updateProjectNameInGradlePath"));
        }
        if (moduleDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDir", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "updateProjectNameInGradlePath"));
        }
        String gradlePath = ((AndroidGradleFacetConfiguration)androidGradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
        if (gradlePath.equals(":")) {
            String string = gradlePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "updateProjectNameInGradlePath"));
            }
            return string;
        }
        List<String> pathSegments = GradleUtil.getPathSegments(gradlePath);
        pathSegments.remove(pathSegments.size() - 1);
        pathSegments.add(moduleDir.getName());
        ((AndroidGradleFacetConfiguration)androidGradleFacet.getConfiguration()).GRADLE_PROJECT_PATH = newPath = Joiner.on((String)":").join(pathSegments);
        String string = newPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleBuildFileUpdater", "updateProjectNameInGradlePath"));
        }
        return string;
    }
}

