/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.view;

import com.android.tools.idea.ddms.hprof.RunHprofConvAndSaveAsAction;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.android.tools.idea.profiling.view.CapturesTreeStructure;
import com.android.tools.idea.profiling.view.RenameCaptureFileAction;
import com.android.tools.idea.profiling.view.nodes.CaptureNode;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.actions.DeleteAction;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CapturesToolWindow
extends BulkFileListener.Adapter
implements Disposable,
HierarchyListener,
CaptureService.CaptureListener,
DataProvider,
DeleteProvider {
    public static final String TREE_NAME = "CapturesPaneTree";
    @NotNull
    public static final DataKey<Capture[]> CAPTURE_ARRAY = DataKey.create((String)"CaptureArray");
    @NotNull
    private final AbstractTreeBuilder myBuilder;
    @NotNull
    private final CapturesTreeStructure myStructure;
    @NotNull
    private Project myProject;
    @NotNull
    private SimpleTree myTree;
    @NotNull
    private JScrollPane myComponent;
    private MessageBusConnection myConnection;
    private static final Logger LOG = Logger.getInstance(CapturesToolWindow.class);

    public CapturesToolWindow(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/profiling/view/CapturesToolWindow", "<init>"));
        }
        this.myProject = project;
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new SimpleTree((TreeModel)model);
        this.myTree.setName(TREE_NAME);
        this.myTree.setRootVisible(false);
        this.myComponent = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        this.myStructure = new CapturesTreeStructure(this.myProject);
        this.myBuilder = new AbstractTreeBuilder((JTree)this.myTree, model, (AbstractTreeStructure)this.myStructure, null);
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        Disposer.register((Disposable)project, (Disposable)this);
        this.myBuilder.initRootNode();
        this.myBuilder.getInitialized().doWhenDone(new Runnable(){

            @Override
            public void run() {
                CapturesToolWindow.this.myBuilder.getUi().expandAll(null);
            }
        });
        this.myTree.addHierarchyListener((HierarchyListener)this);
        CaptureService.getInstance(this.myProject).addListener(this);
        CaptureService.getInstance(this.myProject).update();
        this.myStructure.update();
        this.myTree.setPopupGroup(this.getPopupActions(), "Context");
        this.myTree.putClientProperty((Object)"DataProvider", (Object)this);
    }

    private ActionGroup getPopupActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ExpandAllAction((JTree)this.myTree));
        group.add((AnAction)new CollapseAllAction((JTree)this.myTree));
        group.addSeparator();
        group.add((AnAction)new RevealFileAction());
        group.add((AnAction)new RenameCaptureFileAction((JComponent)this.myTree));
        group.add((AnAction)new DeleteAction());
        group.addSeparator();
        group.add((AnAction)new RunHprofConvAndSaveAsAction());
        return group;
    }

    @NotNull
    public JComponent getComponent() {
        JScrollPane jScrollPane = this.myComponent;
        if (jScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/view/CapturesToolWindow", "getComponent"));
        }
        return jScrollPane;
    }

    public void dispose() {
        if (this.myConnection != null) {
            this.myConnection.disconnect();
            this.myConnection = null;
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/android/tools/idea/profiling/view/CapturesToolWindow", "after"));
        }
        CaptureService service = CaptureService.getInstance(this.myProject);
        VirtualFile captures = service.getCapturesDirectory();
        if (captures == null) {
            if (!service.getCaptures().isEmpty()) {
                this.queueUpdate();
            }
            return;
        }
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent.getFile() == null || !VfsUtilCore.isAncestor((VirtualFile)captures, (VirtualFile)vFileEvent.getFile(), (boolean)false)) continue;
            this.queueUpdate();
            return;
        }
    }

    public void queueUpdate() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                CaptureService.getInstance(CapturesToolWindow.this.myProject).update();
                CapturesToolWindow.this.myStructure.update();
                CapturesToolWindow.this.myBuilder.updateFromRoot();
            }
        });
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
            if (this.myTree.isShowing()) {
                if (this.myConnection == null) {
                    this.myConnection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
                    this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
                }
            } else if (this.myConnection != null) {
                this.myConnection.disconnect();
                this.myConnection = null;
            }
        }
    }

    @Override
    public void onReady(Capture capture) {
        this.myStructure.update();
        this.myBuilder.updateFromRoot();
        this.myTree.setSelectedNode(this.myBuilder, (SimpleNode)this.myStructure.getNode(capture), true);
    }

    @NotNull
    private VirtualFile[] getSelectedFiles() {
        CaptureNode[] nodes = this.getSelectedCaptureNodes();
        VirtualFile[] files = new VirtualFile[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            files[i] = nodes[i].getCapture().getFile();
        }
        if (files == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/view/CapturesToolWindow", "getSelectedFiles"));
        }
        return files;
    }

    @NotNull
    private Capture[] getSelectedCaptures() {
        CaptureNode[] nodes = this.getSelectedCaptureNodes();
        Capture[] captures = new Capture[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            captures[i] = nodes[i].getCapture();
        }
        if (captures == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/view/CapturesToolWindow", "getSelectedCaptures"));
        }
        return captures;
    }

    @NotNull
    private CaptureNode[] getSelectedCaptureNodes() {
        SimpleNode[] nodes = this.myTree.getSelectedNodesIfUniform();
        CaptureNode[] captureNodeArray = nodes.length > 0 && nodes[0] instanceof CaptureNode ? (CaptureNode[])Arrays.copyOf(nodes, nodes.length, CaptureNode[].class) : new CaptureNode[]{};
        if (captureNodeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/view/CapturesToolWindow", "getSelectedCaptureNodes"));
        }
        return captureNodeArray;
    }

    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            VirtualFile[] files = this.getSelectedFiles();
            return files.length == 1 ? files[0] : null;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this;
        }
        if (CAPTURE_ARRAY.is(dataId)) {
            return this.getSelectedCaptures();
        }
        return null;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/profiling/view/CapturesToolWindow", "deleteElement"));
        }
        final VirtualFile[] files = this.getSelectedFiles();
        if (files.length > 0) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    for (VirtualFile file : files) {
                        try {
                            file.delete(null);
                        }
                        catch (IOException e) {
                            LOG.error("Cannot delete file " + file.getPath());
                        }
                    }
                }
            });
        }
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/profiling/view/CapturesToolWindow", "canDeleteElement"));
        }
        return this.getSelectedFiles().length > 0;
    }
}

