/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal.packages;

import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.NoPreviewRevision;
import com.android.sdklib.repository.descriptors.IPkgDescExtra;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgDescExtra;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalExtraPkgInfo;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.IMinApiLevelDependency;
import com.android.tools.idea.sdk.remote.internal.packages.IMinToolsDependency;
import com.android.tools.idea.sdk.remote.internal.packages.MinToolsMixin;
import com.android.tools.idea.sdk.remote.internal.packages.RemotePackageParserUtils;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public class RemoteExtraPkgInfo
extends RemotePkgInfo
implements IMinApiLevelDependency,
IMinToolsDependency {
    private final MinToolsMixin mMinToolsMixin;
    private final String mDisplayName;
    private final String mPath;
    private final String mOldPaths;
    private final int mMinApiLevel;
    private final String[] mProjectFiles;

    public RemoteExtraPkgInfo(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        String vendor;
        this.mMinToolsMixin = new MinToolsMixin(packageNode);
        this.mPath = RemotePackageParserUtils.getXmlString(packageNode, "path");
        String name = RemotePackageParserUtils.getXmlString(packageNode, "name-display");
        String vname = RemotePackageParserUtils.getXmlString(packageNode, "vendor-display");
        String vid = RemotePackageParserUtils.getXmlString(packageNode, "vendor-id");
        if (vid.length() == 0) {
            vendor = RemotePackageParserUtils.getXmlString(packageNode, "vendor");
            vid = this.sanitizeLegacyVendor(vendor);
            if (vname.length() == 0) {
                vname = vendor;
            }
        }
        if (vname.length() == 0) {
            vname = vid;
        }
        vendor = new IdDisplay(vid.trim(), vname.trim());
        if (name.length() == 0) {
            name = LocalExtraPkgInfo.getPrettyName((IdDisplay)vendor, (String)this.mPath);
        }
        this.mDisplayName = name.trim();
        this.mMinApiLevel = RemotePackageParserUtils.getXmlInt(packageNode, "min-api-level", 0);
        this.mProjectFiles = this.parseProjectFiles(RemotePackageParserUtils.findChildElement(packageNode, "project-files"));
        this.mOldPaths = RemotePackageParserUtils.getXmlString(packageNode, "old-paths");
        FullRevision revision = this.getRevision();
        PkgDesc.Builder pkgDescBuilder = PkgDesc.Builder.newExtra((IdDisplay)vendor, (String)this.mPath, (String)this.mDisplayName, (String[])this.getOldPaths(), (NoPreviewRevision)new NoPreviewRevision(revision.getMajor(), revision.getMinor(), revision.getMicro()));
        pkgDescBuilder.setDescriptionShort(RemoteExtraPkgInfo.createShortDescription(this.mListDisplay, this.getRevision(), this.mDisplayName, this.isObsolete()));
        pkgDescBuilder.setDescriptionUrl(this.getDescUrl());
        pkgDescBuilder.setListDisplay(RemoteExtraPkgInfo.createListDescription(this.mListDisplay, this.mDisplayName, this.isObsolete()));
        pkgDescBuilder.setIsObsolete(this.isObsolete());
        pkgDescBuilder.setLicense(this.getLicense());
        this.mPkgDesc = pkgDescBuilder.create();
    }

    private String[] parseProjectFiles(Node projectFilesNode) {
        ArrayList<String> paths = new ArrayList<String>();
        if (projectFilesNode != null) {
            String nsUri = projectFilesNode.getNamespaceURI();
            for (Node child = projectFilesNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                String path;
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || !"path".equals(child.getLocalName()) || (path = child.getTextContent()) == null || (path = path.trim()).length() <= 0) continue;
                paths.add(path);
            }
        }
        return paths.toArray(new String[paths.size()]);
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        this.mMinToolsMixin.saveProperties(props);
        props.setProperty("Extra.Path", this.mPath);
        props.setProperty("Extra.NameDisplay", this.mDisplayName);
        props.setProperty("Extra.VendorDisplay", this.getPkgDesc().getVendor().getDisplay());
        props.setProperty("Extra.VendorId", this.getPkgDesc().getVendor().getId());
        if (this.getMinApiLevel() != 0) {
            props.setProperty("Extra.MinApiLevel", Integer.toString(this.getMinApiLevel()));
        }
        if (this.mProjectFiles.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.mProjectFiles.length; ++i) {
                if (i > 0) {
                    sb.append(File.pathSeparatorChar);
                }
                sb.append(this.mProjectFiles[i]);
            }
            props.setProperty("Extra.ProjectFiles", sb.toString());
        }
        if (this.mOldPaths != null && this.mOldPaths.length() > 0) {
            props.setProperty("Extra.OldPaths", this.mOldPaths);
        }
    }

    @Override
    public FullRevision getMinToolsRevision() {
        return this.mMinToolsMixin.getMinToolsRevision();
    }

    @Override
    public int getMinApiLevel() {
        return this.mMinApiLevel;
    }

    public String[] getProjectFiles() {
        return this.mProjectFiles;
    }

    public String[] getOldPaths() {
        return PkgDescExtra.convertOldPaths((String)this.mOldPaths);
    }

    public String getPath() {
        String path = this.mPath.replaceAll("[^a-zA-Z0-9-]+", "_");
        if (path.length() == 0 || path.equals("_")) {
            int h = path.hashCode();
            path = String.format("extra%08x", h);
        }
        return path;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    private String sanitizeLegacyVendor(String vendorDisplay) {
        if (vendorDisplay != null && vendorDisplay.length() > 0) {
            String vendor = vendorDisplay.trim();
            if ((vendor = vendor.replaceAll("[^a-zA-Z0-9-]+", "_")).equals("_")) {
                int h = vendor.hashCode();
                vendor = String.format("vendor%08x", h);
            }
            return vendor;
        }
        return "";
    }

    @Override
    public String installId() {
        return String.format("extra-%1$s-%2$s", this.getPkgDesc().getVendor().getId(), this.getPath());
    }

    private static String createListDescription(String listDisplay, String displayName, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s%2$s", listDisplay, obsolete ? " (Obsolete)" : "");
        }
        String s = String.format("%1$s%2$s", displayName, obsolete ? " (Obsolete)" : "");
        return s;
    }

    private static String createShortDescription(String listDisplay, FullRevision revision, String displayName, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", listDisplay, revision.toShortString(), obsolete ? " (Obsolete)" : "");
        }
        String s = String.format("%1$s, revision %2$s%3$s", displayName, revision.toShortString(), obsolete ? " (Obsolete)" : "");
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        LocalSdk sdk = sdkManager.getLocalSdk();
        for (LocalPkgInfo info : sdk.getPkgsInfos(PkgType.PKG_EXTRA)) {
            if (!PkgDescExtra.compatibleVendorAndPath((IPkgDescExtra)((IPkgDescExtra)this.mPkgDesc), (IPkgDescExtra)((IPkgDescExtra)info.getDesc()))) continue;
            return info.getLocalDir();
        }
        return this.getInstallSubFolder(osSdkRoot);
    }

    private File getInstallSubFolder(String osSdkRoot) {
        String name;
        File path = new File(osSdkRoot, "extras");
        String vendor = this.getPkgDesc().getVendor().getId();
        if (vendor != null && vendor.length() > 0) {
            path = new File(path, vendor);
        }
        if ((name = this.getPath()) != null && name.length() > 0) {
            path = new File(path, name);
        }
        return path;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.mMinToolsMixin.hashCode(super.hashCode());
        result = 31 * result + this.mMinApiLevel;
        result = 31 * result + (this.mPath == null ? 0 : this.mPath.hashCode());
        result = 31 * result + Arrays.hashCode(this.mProjectFiles);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RemoteExtraPkgInfo)) {
            return false;
        }
        RemoteExtraPkgInfo other = (RemoteExtraPkgInfo)obj;
        if (this.mMinApiLevel != other.mMinApiLevel) {
            return false;
        }
        if (this.mPath == null ? other.mPath != null : !this.mPath.equals(other.mPath)) {
            return false;
        }
        if (!Arrays.equals(this.mProjectFiles, other.mProjectFiles)) {
            return false;
        }
        return this.mMinToolsMixin.equals(obj);
    }

    @Override
    public boolean sameItemAs(LocalPkgInfo pkg, FullRevision.PreviewComparison previewComparison) {
        if (pkg instanceof LocalExtraPkgInfo) {
            LocalExtraPkgInfo ep = (LocalExtraPkgInfo)pkg;
            return PkgDescExtra.compatibleVendorAndPath((IPkgDescExtra)((IPkgDescExtra)this.mPkgDesc), (IPkgDescExtra)((IPkgDescExtra)ep.getDesc()));
        }
        return false;
    }
}

