/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.ui;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterators;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationComponent<T extends Item>
extends JEditorPane {
    private boolean myDisplaySingleRoot;
    private final ArrayList<ItemListener<T>> myItemListeners = new ArrayList();
    private final LinkedList<T> myItemStack = new LinkedList();
    private boolean hasRootItem = false;

    public NavigationComponent() {
        this.setEditable(false);
        this.setContentType(ContentType.TEXT_HTML.getMimeType());
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        ((HTMLDocument)this.getDocument()).getStyleSheet().addRule("a { text-decoration:none; }");
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                int idx = Integer.parseInt(e.getDescription());
                final Item item = (Item)NavigationComponent.this.myItemStack.get(idx);
                for (final ItemListener listener : NavigationComponent.this.myItemListeners) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            listener.itemSelected(item);
                        }
                    });
                }
            }
        });
    }

    public void addItemListener(@NotNull ItemListener<T> itemListener) {
        if (itemListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemListener", "com/android/tools/swing/ui/NavigationComponent", "addItemListener"));
        }
        this.myItemListeners.add(itemListener);
    }

    public void removeItemListener(@NotNull ItemListener<T> itemListener) {
        if (itemListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemListener", "com/android/tools/swing/ui/NavigationComponent", "removeItemListener"));
        }
        this.myItemListeners.remove(itemListener);
    }

    private void updateText() {
        if (this.myItemStack.isEmpty()) {
            this.setText("");
            return;
        }
        if (this.myItemStack.size() == 1 && this.hasRootItem && !this.myDisplaySingleRoot) {
            this.setText("");
            return;
        }
        final AtomicInteger id = new AtomicInteger(this.myItemStack.size() - 1);
        String text = Joiner.on((String)" &gt; ").join(Iterators.transform(this.myItemStack.descendingIterator(), (Function)new Function<T, String>(){

            public String apply(T input) {
                if (id.get() == 0) {
                    return ((Item)input).getDisplayText();
                }
                return String.format("<a href=\"%d\">%s</a>", id.getAndDecrement(), ((Item)input).getDisplayText());
            }

            public boolean equals(Object object) {
                return false;
            }
        }));
        this.setText(text);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        boolean hasContentToDisplay = this.myDisplaySingleRoot ? this.hasRootItem : this.myItemStack.size() > 1;
        return hasContentToDisplay ? new Dimension(0, this.getFontMetrics(this.getFont()).getHeight()) : super.getMinimumSize();
    }

    public void setDisplaySingleRoot(boolean displaySingleRoot) {
        this.myDisplaySingleRoot = displaySingleRoot;
    }

    public void setRootItem(@Nullable T item) {
        if (this.hasRootItem) {
            this.myItemStack.removeFirst();
        }
        this.hasRootItem = item != null;
        this.myItemStack.addFirst(item);
        this.updateText();
    }

    public void push(@NotNull T item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/swing/ui/NavigationComponent", "push"));
        }
        if (item.equals(this.peek())) {
            return;
        }
        this.myItemStack.push(item);
        this.updateText();
    }

    @Nullable
    public T pop() {
        if (this.myItemStack.size() == 1 && this.hasRootItem) {
            return null;
        }
        Item removed = (Item)this.myItemStack.pop();
        this.updateText();
        return (T)removed;
    }

    @Nullable
    public T peek() {
        return (T)((Item)this.myItemStack.peek());
    }

    public void goTo(@NotNull T goToItem) {
        T item;
        if (goToItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "goToItem", "com/android/tools/swing/ui/NavigationComponent", "goTo"));
        }
        while ((item = this.peek()) != null) {
            if (goToItem.equals(item)) {
                return;
            }
            if (this.pop() != null) continue;
            return;
        }
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        return new Dimension(Integer.MAX_VALUE, this.getFontMetrics(this.getFont()).getHeight());
    }

    public static interface ItemListener<T extends Item> {
        public void itemSelected(@NotNull T var1);
    }

    public static abstract class Item {
        @NotNull
        public abstract String getDisplayText();
    }
}

