/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.formatter;

import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlPolicy;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.formatter.AndroidXmlPolicy;

public class AndroidXmlCodeStyleSettings
extends CustomCodeStyleSettings {
    public boolean USE_CUSTOM_SETTINGS = false;
    public LayoutSettings LAYOUT_SETTINGS = new LayoutSettings();
    public ManifestSettings MANIFEST_SETTINGS = new ManifestSettings();
    public ValueResourceFileSettings VALUE_RESOURCE_FILE_SETTINGS = new ValueResourceFileSettings();
    public OtherSettings OTHER_SETTINGS = new OtherSettings();

    public AndroidXmlCodeStyleSettings(CodeStyleSettings container) {
        super("AndroidXmlCodeStyleSettings", container);
    }

    public static AndroidXmlCodeStyleSettings getInstance(CodeStyleSettings settings) {
        return (AndroidXmlCodeStyleSettings)settings.getCustomSettings(AndroidXmlCodeStyleSettings.class);
    }

    public Object clone() {
        try {
            AndroidXmlCodeStyleSettings cloned = (AndroidXmlCodeStyleSettings)((Object)super.clone());
            cloned.LAYOUT_SETTINGS = (LayoutSettings)this.LAYOUT_SETTINGS.clone();
            cloned.MANIFEST_SETTINGS = (ManifestSettings)this.MANIFEST_SETTINGS.clone();
            cloned.VALUE_RESOURCE_FILE_SETTINGS = (ValueResourceFileSettings)this.VALUE_RESOURCE_FILE_SETTINGS.clone();
            cloned.OTHER_SETTINGS = (OtherSettings)this.OTHER_SETTINGS.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class OtherSettings
    extends MySettings {
        public OtherSettings() {
            this.WRAP_ATTRIBUTES = 2;
            this.INSERT_LINE_BREAK_BEFORE_FIRST_ATTRIBUTE = true;
        }
    }

    public static class ValueResourceFileSettings
    extends MySettings {
        public boolean INSERT_LINE_BREAKS_AROUND_STYLE = true;

        public ValueResourceFileSettings() {
            this.WRAP_ATTRIBUTES = 0;
            this.INSERT_LINE_BREAK_BEFORE_FIRST_ATTRIBUTE = false;
        }

        @Override
        public XmlPolicy createXmlPolicy(CodeStyleSettings settings, FormattingDocumentModel documentModel) {
            return new AndroidXmlPolicy(settings, this, documentModel){

                public boolean insertLineBreakAfterTagBegin(XmlTag tag) {
                    if (!INSERT_LINE_BREAKS_AROUND_STYLE) {
                        return false;
                    }
                    XmlTag[] subTags = tag.getSubTags();
                    return subTags.length != 0 && this.isStyleTag(subTags[0]);
                }

                public boolean keepWhiteSpacesInsideTag(XmlTag tag) {
                    if (super.keepWhiteSpacesInsideTag(tag)) {
                        return true;
                    }
                    boolean inItem = false;
                    while (tag != null) {
                        String tagName = tag.getName();
                        if ("item".equals(tagName)) {
                            inItem = true;
                        } else {
                            if ("string".equals(tagName)) {
                                return true;
                            }
                            if ("string-array".equals(tagName) || "plurals".equals(tagName)) {
                                return inItem;
                            }
                        }
                        tag = tag.getParentTag();
                    }
                    return false;
                }

                public boolean insertLineBreakBeforeTag(XmlTag xmlTag) {
                    if (!INSERT_LINE_BREAKS_AROUND_STYLE) {
                        return false;
                    }
                    if (this.isStyleTag(xmlTag)) {
                        return true;
                    }
                    PsiElement sibling = 1.getPrevSiblingElement((PsiElement)xmlTag);
                    return sibling instanceof XmlTag && this.isStyleTag((XmlTag)sibling);
                }

                private boolean isStyleTag(XmlTag tag) {
                    return DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag) instanceof Style;
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ValueResourceFileSettings settings = (ValueResourceFileSettings)o;
            return this.INSERT_LINE_BREAKS_AROUND_STYLE == settings.INSERT_LINE_BREAKS_AROUND_STYLE;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.INSERT_LINE_BREAKS_AROUND_STYLE ? 1 : 0);
            return result;
        }
    }

    public static class ManifestSettings
    extends MySettings {
        public boolean GROUP_TAGS_WITH_SAME_NAME = true;

        public ManifestSettings() {
            this.WRAP_ATTRIBUTES = 2;
            this.INSERT_LINE_BREAK_BEFORE_FIRST_ATTRIBUTE = true;
        }

        @Override
        public XmlPolicy createXmlPolicy(CodeStyleSettings settings, FormattingDocumentModel documentModel) {
            return new AndroidXmlPolicy(settings, this, documentModel){

                public boolean insertLineBreakBeforeTag(XmlTag xmlTag) {
                    String name2;
                    String name1;
                    PsiElement element;
                    if (GROUP_TAGS_WITH_SAME_NAME && (element = 1.getPrevSiblingElement((PsiElement)xmlTag)) instanceof XmlTag && !(name1 = ((XmlTag)element).getName()).equals(name2 = xmlTag.getName())) {
                        if ((element = 1.getPrevSiblingElement(element)) instanceof XmlTag && ((XmlTag)element).getName().equals(name1)) {
                            return true;
                        }
                        element = 1.getNextSiblingElement((PsiElement)xmlTag);
                        return element instanceof XmlTag && ((XmlTag)element).getName().equals(name2);
                    }
                    return false;
                }

                public boolean insertLineBreakAfterTagBegin(XmlTag tag) {
                    return GROUP_TAGS_WITH_SAME_NAME && tag.getParentTag() == null;
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ManifestSettings settings = (ManifestSettings)o;
            return this.GROUP_TAGS_WITH_SAME_NAME == settings.GROUP_TAGS_WITH_SAME_NAME;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.GROUP_TAGS_WITH_SAME_NAME ? 1 : 0);
            return result;
        }
    }

    public static class LayoutSettings
    extends MySettings {
        public boolean INSERT_BLANK_LINE_BEFORE_TAG = true;

        public LayoutSettings() {
            this.WRAP_ATTRIBUTES = 2;
            this.INSERT_LINE_BREAK_BEFORE_FIRST_ATTRIBUTE = true;
        }

        @Override
        public XmlPolicy createXmlPolicy(CodeStyleSettings settings, FormattingDocumentModel documentModel) {
            return new AndroidXmlPolicy(settings, this, documentModel){

                public boolean insertLineBreakBeforeTag(XmlTag xmlTag) {
                    return INSERT_BLANK_LINE_BEFORE_TAG || super.insertLineBreakBeforeTag(xmlTag);
                }

                public boolean insertLineBreakAfterTagBegin(XmlTag tag) {
                    return INSERT_BLANK_LINE_BEFORE_TAG;
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LayoutSettings settings = (LayoutSettings)o;
            return this.INSERT_BLANK_LINE_BEFORE_TAG == settings.INSERT_BLANK_LINE_BEFORE_TAG;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.INSERT_BLANK_LINE_BEFORE_TAG ? 1 : 0);
            return result;
        }
    }

    public static class MySettings
    implements JDOMExternalizable,
    Cloneable {
        public int WRAP_ATTRIBUTES;
        public boolean INSERT_LINE_BREAK_BEFORE_FIRST_ATTRIBUTE;
        public boolean INSERT_LINE_BREAK_AFTER_LAST_ATTRIBUTE;

        public void readExternal(Element element) throws InvalidDataException {
            XmlSerializer.deserializeInto((Object)this, (Element)element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            XmlSerializer.serializeInto((Object)this, (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        }

        public XmlPolicy createXmlPolicy(CodeStyleSettings settings, FormattingDocumentModel documentModel) {
            return new AndroidXmlPolicy(settings, this, documentModel);
        }

        protected MySettings clone() throws CloneNotSupportedException {
            try {
                return (MySettings)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MySettings s = (MySettings)o;
            return this.INSERT_LINE_BREAK_BEFORE_FIRST_ATTRIBUTE == s.INSERT_LINE_BREAK_BEFORE_FIRST_ATTRIBUTE && this.INSERT_LINE_BREAK_AFTER_LAST_ATTRIBUTE == s.INSERT_LINE_BREAK_AFTER_LAST_ATTRIBUTE && this.WRAP_ATTRIBUTES == s.WRAP_ATTRIBUTES;
        }

        public int hashCode() {
            int result = this.WRAP_ATTRIBUTES;
            result = 31 * result + (this.INSERT_LINE_BREAK_BEFORE_FIRST_ATTRIBUTE ? 1 : 0);
            result = 31 * result + (this.INSERT_LINE_BREAK_AFTER_LAST_ATTRIBUTE ? 1 : 0);
            return result;
        }
    }
}

