/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceType;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.CreateFileResourceQuickFix;
import org.jetbrains.android.inspections.CreateValueResourceQuickFix;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidResourceQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiReferenceExpression> {
    public void registerFixes(@NotNull PsiReferenceExpression exp, @NotNull QuickFixActionRegistrar registrar) {
        PsiElement parent;
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "org/jetbrains/android/inspections/AndroidResourceQuickFixProvider", "registerFixes"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/android/inspections/AndroidResourceQuickFixProvider", "registerFixes"));
        }
        Module contextModule = ModuleUtil.findModuleForPsiElement((PsiElement)exp);
        if (contextModule == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(contextModule);
        if (facet == null) {
            return;
        }
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return;
        }
        String aPackage = (String)manifest.getPackage().getValue();
        if (aPackage == null) {
            return;
        }
        PsiFile contextFile = exp.getContainingFile();
        if (contextFile == null) {
            return;
        }
        AndroidResourceUtil.MyReferredResourceFieldInfo info = AndroidResourceUtil.getReferredResourceOrManifestField(facet, exp, true);
        if (info == null && (parent = exp.getParent()) instanceof PsiReferenceExpression) {
            info = AndroidResourceUtil.getReferredResourceOrManifestField(facet, (PsiReferenceExpression)parent, true);
        }
        if (info == null || info.isFromManifest()) {
            return;
        }
        String resClassName = info.getClassName();
        String resFieldName = info.getFieldName();
        ResourceType resourceType = ResourceType.getEnum((String)resClassName);
        if (AndroidResourceUtil.ALL_VALUE_RESOURCE_TYPES.contains(resourceType)) {
            registrar.register((IntentionAction)new CreateValueResourceQuickFix(facet, resourceType, resFieldName, contextFile, true));
        }
        if (AndroidResourceUtil.XML_FILE_RESOURCE_TYPES.contains(resourceType)) {
            registrar.register((IntentionAction)new CreateFileResourceQuickFix(facet, resourceType, resFieldName, contextFile, true));
        }
    }

    @NotNull
    public Class<PsiReferenceExpression> getReferenceClass() {
        if (PsiReferenceExpression.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/AndroidResourceQuickFixProvider", "getReferenceClass"));
        }
        return PsiReferenceExpression.class;
    }
}

