/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.util.text.StringUtil;

public class JavaTestUtil {
    private static final String TEST_JDK_NAME = "JDK";

    public static String getJavaTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    public static String getRelativeJavaTestDataPath() {
        String absolute = JavaTestUtil.getJavaTestDataPath();
        return StringUtil.trimStart((String)absolute, (String)PathManager.getHomePath());
    }

    public static void setupTestJDK() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
                Sdk jdk = jdkTable.findJdk(JavaTestUtil.TEST_JDK_NAME);
                if (jdk != null) {
                    jdkTable.removeJdk(jdk);
                }
                jdkTable.addJdk(JavaTestUtil.getTestJdk());
            }
        });
    }

    public static Sdk getTestJdk() {
        try {
            ProjectJdkImpl jdk = (ProjectJdkImpl)JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk().clone();
            jdk.setName(TEST_JDK_NAME);
            return jdk;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

