/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EmptyAction
extends AnAction {
    private boolean myEnabled;

    public EmptyAction() {
    }

    public EmptyAction(boolean enabled) {
        this.myEnabled = enabled;
    }

    public EmptyAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    public static AnAction createEmptyAction(@Nullable String name, @Nullable Icon icon, boolean alwaysEnabled) {
        EmptyAction emptyAction = new EmptyAction(name, null, icon);
        emptyAction.myEnabled = alwaysEnabled;
        return emptyAction;
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
    }

    @Override
    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(this.myEnabled);
    }

    public static void setupAction(@NotNull AnAction action, @NotNull String id, @Nullable JComponent component) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/actionSystem/EmptyAction", "setupAction"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/actionSystem/EmptyAction", "setupAction"));
        }
        AnAction emptyAction = ActionManager.getInstance().getAction(id);
        Presentation copyFrom = emptyAction.getTemplatePresentation();
        Presentation copyTo = action.getTemplatePresentation();
        if (copyTo.getIcon() == null) {
            copyTo.setIcon(copyFrom.getIcon());
        }
        copyTo.setText(copyFrom.getText());
        copyTo.setDescription(copyFrom.getDescription());
        action.registerCustomShortcutSet(emptyAction.getShortcutSet(), component);
    }

    public static void registerActionShortcuts(JComponent component, JComponent fromComponent) {
        for (AnAction anAction : ActionUtil.getActions(fromComponent)) {
            anAction.registerCustomShortcutSet(anAction.getShortcutSet(), component);
        }
    }

    public static void registerWithShortcutSet(@NotNull String id, @NotNull ShortcutSet shortcutSet, @NotNull JComponent component) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/actionSystem/EmptyAction", "registerWithShortcutSet"));
        }
        if (shortcutSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcutSet", "com/intellij/openapi/actionSystem/EmptyAction", "registerWithShortcutSet"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/actionSystem/EmptyAction", "registerWithShortcutSet"));
        }
        AnAction newAction = EmptyAction.wrap(ActionManager.getInstance().getAction(id));
        newAction.registerCustomShortcutSet(shortcutSet, component);
    }

    public static AnAction wrap(AnAction action) {
        return action instanceof ActionGroup ? new MyDelegatingActionGroup((ActionGroup)action) : new MyDelegatingAction(action);
    }

    private static class MyDelegatingActionGroup
    extends ActionGroup {
        @NotNull
        private final ActionGroup myDelegate;

        public MyDelegatingActionGroup(@NotNull ActionGroup action) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/actionSystem/EmptyAction$MyDelegatingActionGroup", "<init>"));
            }
            this.myDelegate = action;
            this.copyFrom(action);
            this.setEnabledInModalContext(action.isEnabledInModalContext());
        }

        @Override
        public boolean isPopup() {
            return this.myDelegate.isPopup();
        }

        @Override
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = this.myDelegate.getChildren(e);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/EmptyAction$MyDelegatingActionGroup", "getChildren"));
            }
            return anActionArray;
        }

        @Override
        public void update(AnActionEvent e) {
            this.myDelegate.update(e);
        }

        @Override
        public boolean canBePerformed(DataContext context) {
            return this.myDelegate.canBePerformed(context);
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            this.myDelegate.actionPerformed(e);
        }

        @Override
        public boolean isDumbAware() {
            return this.myDelegate.isDumbAware();
        }

        @Override
        public boolean isTransparentUpdate() {
            return this.myDelegate.isTransparentUpdate();
        }

        @Override
        public boolean isInInjectedContext() {
            return this.myDelegate.isInInjectedContext();
        }

        @Override
        public boolean hideIfNoVisibleChildren() {
            return this.myDelegate.hideIfNoVisibleChildren();
        }

        @Override
        public boolean disableIfNoVisibleChildren() {
            return this.myDelegate.disableIfNoVisibleChildren();
        }
    }

    private static class MyDelegatingAction
    extends AnAction {
        @NotNull
        private final AnAction myDelegate;

        public MyDelegatingAction(@NotNull AnAction action) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/actionSystem/EmptyAction$MyDelegatingAction", "<init>"));
            }
            this.myDelegate = action;
            this.copyFrom(action);
            this.setEnabledInModalContext(action.isEnabledInModalContext());
        }

        @Override
        public void update(AnActionEvent e) {
            this.myDelegate.update(e);
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            this.myDelegate.actionPerformed(e);
        }

        @Override
        public boolean isDumbAware() {
            return this.myDelegate.isDumbAware();
        }

        @Override
        public boolean isTransparentUpdate() {
            return this.myDelegate.isTransparentUpdate();
        }

        @Override
        public boolean isInInjectedContext() {
            return this.myDelegate.isInInjectedContext();
        }
    }
}

