/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;

public class FileChooserDescriptorFactory {
    private FileChooserDescriptorFactory() {
    }

    public static FileChooserDescriptor createAllButJarContentsDescriptor() {
        return new FileChooserDescriptor(true, true, true, true, false, true);
    }

    public static FileChooserDescriptor createMultipleFilesNoJarsDescriptor() {
        return new FileChooserDescriptor(true, false, false, false, false, true);
    }

    public static FileChooserDescriptor createMultipleFoldersDescriptor() {
        return new FileChooserDescriptor(false, true, false, false, false, true);
    }

    public static FileChooserDescriptor createSingleFileNoJarsDescriptor() {
        return new FileChooserDescriptor(true, false, false, false, false, false);
    }

    public static FileChooserDescriptor createSingleFileOrExecutableAppDescriptor() {
        return new FileChooserDescriptor(true, false, false, false, false, false){

            @Override
            public boolean isFileSelectable(VirtualFile file) {
                return super.isFileSelectable(file) || SystemInfo.isMac && file.isDirectory() && "app".equals(file.getExtension());
            }
        };
    }

    public static FileChooserDescriptor createSingleLocalFileDescriptor() {
        return new FileChooserDescriptor(true, true, true, true, false, false);
    }

    public static FileChooserDescriptor createSingleFileDescriptor() {
        return FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
    }

    public static FileChooserDescriptor createSingleFileDescriptor(final FileType fileType) {
        return new FileChooserDescriptor(true, false, false, false, false, false).withFileFilter(new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return file.getFileType() == fileType;
            }
        });
    }

    public static FileChooserDescriptor createSingleFileDescriptor(final String extension) {
        return new FileChooserDescriptor(true, false, false, false, false, false).withFileFilter(new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return Comparing.equal((String)file.getExtension(), (String)extension, (boolean)SystemInfo.isFileSystemCaseSensitive);
            }
        });
    }

    public static FileChooserDescriptor createSingleFolderDescriptor() {
        return new FileChooserDescriptor(false, true, false, false, false, false);
    }

    public static FileChooserDescriptor createMultipleJavaPathDescriptor() {
        return new FileChooserDescriptor(false, true, true, false, true, true);
    }

    public static FileChooserDescriptor createSingleFileOrFolderDescriptor() {
        return new FileChooserDescriptor(true, true, false, false, false, false);
    }

    public static FileChooserDescriptor createSingleFileOrFolderDescriptor(final FileType fileType) {
        return new FileChooserDescriptor(true, true, false, false, false, false).withFileFilter(new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return file.getFileType() == fileType;
            }
        });
    }

    public static FileChooserDescriptor getDirectoryChooserDescriptor(String objectName) {
        return FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle("Select " + objectName);
    }
}

