/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.psi.Weigher;
import com.intellij.psi.WeighingComparable;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeighingService {
    private static final KeyedExtensionCollector<Weigher, Key> COLLECTOR = new KeyedExtensionCollector<Weigher, Key>("com.intellij.weigher"){

        @Override
        @NotNull
        protected String keyToString(@NotNull Key key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/WeighingService$1", "keyToString"));
            }
            String string = key.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/WeighingService$1", "keyToString"));
            }
            return string;
        }
    };

    private WeighingService() {
    }

    @NotNull
    public static <T, Loc> WeighingComparable<T, Loc> weigh(Key<? extends Weigher<T, Loc>> key, T element, @Nullable Loc location) {
        WeighingComparable<T, Loc> weighingComparable = WeighingService.weigh(key, new Computable.PredefinedValueComputable(element), location);
        if (weighingComparable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/WeighingService", "weigh"));
        }
        return weighingComparable;
    }

    @NotNull
    public static <T, Loc> WeighingComparable<T, Loc> weigh(Key<? extends Weigher<T, Loc>> key, Computable<T> element, @Nullable Loc location) {
        List<Weigher> weighers = WeighingService.getWeighers(key);
        WeighingComparable<T, Loc> weighingComparable = new WeighingComparable<T, Loc>(element, location, (Weigher[])ContainerUtil.toArray(weighers, (Object[])new Weigher[weighers.size()]));
        if (weighingComparable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/WeighingService", "weigh"));
        }
        return weighingComparable;
    }

    public static <T, Loc> List<Weigher> getWeighers(Key<? extends Weigher<T, Loc>> key) {
        return COLLECTOR.forKey(key);
    }
}

