/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.util.Alarm;
import com.intellij.util.ui.Animator;

abstract class TwoWayAnimator {
    private final Alarm myAlarm = new Alarm();
    private final MyAnimator myForwardAnimator;
    private final MyAnimator myBackwardAnimator;
    private final int myMaxFrame;
    private int myFrame;

    abstract void onFrame(int var1, int var2);

    TwoWayAnimator(String name, int totalFrames, int cycleDuration, int pauseForward, int pauseBackward) {
        this.myMaxFrame = totalFrames - 1;
        this.myForwardAnimator = new MyAnimator(name + "ForwardAnimator", totalFrames, cycleDuration, pauseForward, true);
        this.myBackwardAnimator = new MyAnimator(name + "BackwardAnimator", totalFrames, cycleDuration, pauseBackward, false);
    }

    void startForward() {
        this.stop();
        this.myForwardAnimator.start();
    }

    void startBackward() {
        this.stop();
        this.myBackwardAnimator.start();
    }

    private void stop() {
        this.myAlarm.cancelAllRequests();
        this.myForwardAnimator.suspend();
        this.myBackwardAnimator.suspend();
    }

    private final class MyAnimator
    extends Animator
    implements Runnable {
        private final int myPause;

        private MyAnimator(String name, int totalFrames, int cycleDuration, int pause, boolean forward) {
            super(name, totalFrames, cycleDuration, false, forward);
            this.myPause = pause;
        }

        private void start() {
            if (this.isForward() ? TwoWayAnimator.this.myFrame > 0 : TwoWayAnimator.this.myFrame < TwoWayAnimator.this.myMaxFrame) {
                this.run();
            } else {
                TwoWayAnimator.this.myAlarm.addRequest((Runnable)this, this.myPause);
            }
        }

        @Override
        public void run() {
            this.reset();
            this.resume();
        }

        @Override
        public void paintNow(int frame, int totalFrames, int cycle) {
            if (this.isForward() ? frame > TwoWayAnimator.this.myFrame : frame < TwoWayAnimator.this.myFrame) {
                TwoWayAnimator.this.myFrame = frame;
                TwoWayAnimator.this.onFrame(TwoWayAnimator.this.myFrame, TwoWayAnimator.this.myMaxFrame);
            }
        }
    }
}

