/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.navigation;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.navigation.HistoryListener;
import com.intellij.ui.navigation.Place;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class History {
    public static DataKey<History> KEY = DataKey.create("History");
    private final List<Place> myHistory;
    private int myCurrentPos;
    private final Place.Navigator myRoot;
    private boolean myNavigatedNow;
    private final CopyOnWriteArraySet<HistoryListener> myListeners;

    public History(@NotNull Place.Navigator root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/ui/navigation/History", "<init>"));
        }
        this.myHistory = new ArrayList<Place>();
        this.myListeners = new CopyOnWriteArraySet();
        this.myRoot = root;
    }

    public void pushQueryPlace() {
        if (this.isNavigatingNow()) {
            return;
        }
        Place place = this.query();
        if (place != null) {
            this.pushPlace(this.query());
        }
    }

    public void pushPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/ui/navigation/History", "pushPlace"));
        }
        while (this.myCurrentPos > 0 && this.myHistory.size() > 0 && this.myCurrentPos < this.myHistory.size() - 1) {
            this.myHistory.remove(this.myHistory.size() - 1);
        }
        if (this.myHistory.size() > 0) {
            Place prev = this.myHistory.get(this.myHistory.size() - 1);
            if (prev.equals(place)) {
                return;
            }
            if (prev.isMoreGeneralFor(place)) {
                this.myHistory.remove(prev);
            }
        }
        this.addPlace(place);
    }

    private void addPlace(Place place) {
        this.myHistory.add(place);
        this.myCurrentPos = this.myHistory.size() - 1;
    }

    public void pushPlaceForElement(String name, Object value) {
        if (!this.canNavigateFor(name)) {
            return;
        }
        Place checkPlace = this.getCheckPlace(name);
        if (checkPlace == null) {
            return;
        }
        this.pushPlace(checkPlace.cloneForElement(name, value));
    }

    public Place getPlaceForElement(String name, String value) {
        Place checkPlace = this.getCheckPlace(name);
        if (checkPlace == null) {
            return new Place();
        }
        return checkPlace.cloneForElement(name, value);
    }

    public void navigateTo(Place place) {
        this.myRoot.navigateTo(place, false);
    }

    public void back() {
        assert (this.canGoBack());
        this.goThere(this.myCurrentPos - 1);
    }

    private void goThere(final int nextPos) {
        this.myNavigatedNow = true;
        final Place next = this.myHistory.get(nextPos);
        final Place from = this.getCurrent();
        this.fireStarted(from, next);
        try {
            ActionCallback callback = this.myRoot.navigateTo(next, false);
            callback.doWhenDone(new Runnable(){

                @Override
                public void run() {
                    History.this.myCurrentPos = nextPos;
                }
            }).doWhenProcessed(new Runnable(){

                @Override
                public void run() {
                    History.this.myNavigatedNow = false;
                    History.this.fireFinished(from, next);
                }
            });
        }
        catch (Throwable e) {
            this.myNavigatedNow = false;
            throw new RuntimeException(e);
        }
    }

    public boolean isNavigatingNow() {
        return this.myNavigatedNow;
    }

    public boolean canGoBack() {
        return this.myHistory.size() > 1 && this.myCurrentPos > 0;
    }

    public void forward() {
        assert (this.canGoForward());
        this.goThere(this.myCurrentPos + 1);
    }

    public boolean canGoForward() {
        return this.myHistory.size() > 1 && this.myCurrentPos < this.myHistory.size() - 1;
    }

    public void clear() {
        this.myHistory.clear();
        this.myCurrentPos = -1;
    }

    public Place query() {
        Place result = new Place();
        this.myRoot.queryPlace(result);
        return result;
    }

    private Place getCurrent() {
        if (this.myCurrentPos >= 0 && this.myCurrentPos < this.myHistory.size()) {
            return this.myHistory.get(this.myCurrentPos);
        }
        return null;
    }

    private boolean canNavigateFor(String pathElement) {
        if (this.isNavigatingNow()) {
            return false;
        }
        Place checkPlace = this.getCheckPlace(pathElement);
        return checkPlace != null && checkPlace.getPath(pathElement) != null;
    }

    @Nullable
    private Place getCheckPlace(String pathElement) {
        Place checkPlace = this.getCurrent();
        if (checkPlace == null || checkPlace.getPath(pathElement) == null) {
            checkPlace = this.query();
        }
        return checkPlace != null && checkPlace.getPath(pathElement) != null ? checkPlace : null;
    }

    public void addListener(final HistoryListener listener, Disposable parent) {
        this.myListeners.add(listener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                History.this.myListeners.remove(listener);
            }
        });
    }

    private void fireStarted(Place from, Place to) {
        for (HistoryListener each : this.myListeners) {
            each.navigationStarted(from, to);
        }
    }

    private void fireFinished(Place from, Place to) {
        for (HistoryListener each : this.myListeners) {
            each.navigationFinished(from, to);
        }
    }
}

