/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.util.Comparing;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;

public class SvnAuthEquals {
    private SvnAuthEquals() {
    }

    public static boolean equals(SVNAuthentication a1, SVNAuthentication a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (!Comparing.equal((String)a1.getKind(), (String)a2.getKind())) {
            return false;
        }
        if (!Comparing.equal((String)a1.getUserName(), (String)a2.getUserName())) {
            return false;
        }
        Class<?> a1Class = a1.getClass();
        if (!a1Class.equals(a2.getClass())) {
            return false;
        }
        if (SVNUserNameAuthentication.class.equals(a1Class)) {
            return true;
        }
        if (SVNPasswordAuthentication.class.equals(a1Class)) {
            return Comparing.equal((String)((SVNPasswordAuthentication)a1).getPassword(), (String)((SVNPasswordAuthentication)a2).getPassword());
        }
        if (SVNSSLAuthentication.class.equals(a1Class)) {
            if (!Comparing.equal((Object)((SVNSSLAuthentication)a1).getCertificateFile(), (Object)((SVNSSLAuthentication)a2).getCertificateFile())) {
                return false;
            }
            return Comparing.equal((String)((SVNSSLAuthentication)a1).getPassword(), (String)((SVNSSLAuthentication)a2).getPassword());
        }
        if (SVNSSHAuthentication.class.equals(a1Class)) {
            if (!Comparing.equal((Object)((SVNSSHAuthentication)a1).getPrivateKeyFile(), (Object)((SVNSSHAuthentication)a2).getPrivateKeyFile())) {
                return false;
            }
            if (!Comparing.equal((String)((SVNSSHAuthentication)a1).getPassphrase(), (String)((SVNSSHAuthentication)a2).getPassphrase())) {
                return false;
            }
            if (!Comparing.equal((Object)((SVNSSHAuthentication)a1).getPortNumber(), (Object)((SVNSSHAuthentication)a2).getPortNumber())) {
                return false;
            }
            return Comparing.equal((String)((SVNSSHAuthentication)a1).getPassword(), (String)((SVNSSHAuthentication)a2).getPassword());
        }
        return false;
    }

    public static int hashCode(SVNAuthentication a) {
        int result = a.getKind().hashCode();
        if (a.getUserName() != null) {
            result = 31 * result + a.getUserName().hashCode();
        }
        return result;
    }
}

