/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkout;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;

public class CheckoutEventHandler
implements ProgressTracker {
    @Nullable
    private final ProgressIndicator myIndicator;
    private int myExternalsCount;
    @NotNull
    private final SvnVcs myVCS;
    private final boolean myIsExport;
    private int myCnt;

    public CheckoutEventHandler(@NotNull SvnVcs vcs, boolean isExport, @Nullable ProgressIndicator indicator) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/checkout/CheckoutEventHandler", "<init>"));
        }
        this.myIndicator = indicator;
        this.myVCS = vcs;
        this.myExternalsCount = 1;
        this.myIsExport = isExport;
        this.myCnt = 0;
    }

    public void consume(ProgressEvent event) {
        if (event.getPath() == null) {
            return;
        }
        if (event.getAction() == EventAction.UPDATE_EXTERNAL) {
            ++this.myExternalsCount;
            this.progress(SvnBundle.message("progress.text2.fetching.external.location", event.getFile().getAbsolutePath()));
        } else if (event.getAction() == EventAction.UPDATE_ADD) {
            this.progress2(SvnBundle.message(this.myIsExport ? "progress.text2.exported" : "progress.text2.checked.out", event.getFile().getName(), this.myCnt));
            ++this.myCnt;
        } else if (event.getAction() == EventAction.UPDATE_COMPLETED) {
            --this.myExternalsCount;
            this.progress2(SvnBundle.message(this.myIsExport ? "progress.text2.exported.revision" : "progress.text2.checked.out.revision", event.getRevision()));
            if (this.myExternalsCount == 0 && event.getRevision() >= 0L) {
                this.myExternalsCount = 1;
                Project project = this.myVCS.getProject();
                if (project != null) {
                    StatusBar.Info.set((String)SvnBundle.message(this.myIsExport ? "progress.text2.exported.revision" : "status.text.checked.out.revision", event.getRevision()), (Project)project);
                }
            }
        } else if (event.getAction() == EventAction.COMMIT_ADDED) {
            this.progress2(SvnBundle.message("progress.text2.adding", event.getPath()));
        } else if (event.getAction() == EventAction.COMMIT_DELTA_SENT) {
            this.progress2(SvnBundle.message("progress.text2.transmitting.delta", event.getPath()));
        }
    }

    @Override
    public void checkCancelled() throws SVNCancelException {
        if (this.myIndicator != null && this.myIndicator.isCanceled()) {
            throw new SVNCancelException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CANCELLED, (String)"Operation cancelled"));
        }
    }

    private void progress(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/idea/svn/checkout/CheckoutEventHandler", "progress"));
        }
        if (this.myIndicator != null) {
            this.myIndicator.checkCanceled();
            this.myIndicator.setText(text);
            this.myIndicator.setText2("");
        } else {
            ProgressManager.progress((String)text);
        }
    }

    private void progress2(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/idea/svn/checkout/CheckoutEventHandler", "progress2"));
        }
        if (this.myIndicator != null) {
            this.myIndicator.checkCanceled();
            this.myIndicator.setText2(text);
        } else {
            ProgressManager.progress2((String)text);
        }
    }
}

