/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.projectView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleNode
extends ProjectViewNode<ResourceBundle>
implements ValidateableNode {
    public ResourceBundleNode(Project project, ResourceBundle resourceBundle, ViewSettings settings) {
        super(project, (Object)resourceBundle, settings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        List<PropertiesFile> propertiesFiles = ((ResourceBundle)this.getValue()).getPropertiesFiles();
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            PsiFileNode node = new PsiFileNode(this.myProject, propertiesFile.getContainingFile(), this.getSettings());
            children.add((AbstractTreeNode)node);
        }
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/projectView/ResourceBundleNode", "getChildren"));
        }
        return arrayList;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/properties/projectView/ResourceBundleNode", "contains"));
        }
        if (!file.isValid()) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(file);
        PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(psiFile);
        return propertiesFile != null && ((ResourceBundle)this.getValue()).getPropertiesFiles().contains(propertiesFile);
    }

    public VirtualFile getVirtualFile() {
        List<PropertiesFile> list = ((ResourceBundle)this.getValue()).getPropertiesFiles();
        if (!list.isEmpty()) {
            return list.get(0).getVirtualFile();
        }
        return null;
    }

    public void update(PresentationData presentation) {
        presentation.setIcon(AllIcons.Nodes.ResourceBundle);
        presentation.setPresentableText(PropertiesBundle.message("project.view.resource.bundle.tree.node.text", ((ResourceBundle)this.getValue()).getBaseName()));
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public boolean canNavigate() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.getProject(), (VirtualFile)new ResourceBundleAsVirtualFile((ResourceBundle)this.getValue()));
        FileEditorManager.getInstance((Project)this.getProject()).openTextEditor(descriptor, requestFocus);
    }

    public boolean isSortByFirstChild() {
        return true;
    }

    public Comparable getTypeSortKey() {
        return new PsiFileNode.ExtensionSortKey(StdFileTypes.PROPERTIES.getDefaultExtension());
    }

    public boolean validate() {
        ResourceBundle currentBundle;
        if (!super.validate()) {
            return false;
        }
        ResourceBundle newBundle = ((ResourceBundle)this.getValue()).getDefaultPropertiesFile().getResourceBundle();
        if (!Comparing.equal((Object)newBundle, (Object)(currentBundle = (ResourceBundle)this.getValue()))) {
            return false;
        }
        return !(currentBundle instanceof ResourceBundleImpl) || ((ResourceBundleImpl)currentBundle).isValid();
    }

    public boolean isValid() {
        return ((ResourceBundle)this.getValue()).getDefaultPropertiesFile().getContainingFile().isValid();
    }
}

