/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.BshMethod;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.TextAreaDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PositionChanging;
import org.gjt.sp.jedit.msg.SearchSettingsChanged;
import org.gjt.sp.jedit.search.BoyerMooreSearchMatcher;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.HyperSearchRequest;
import org.gjt.sp.jedit.search.HyperSearchResults;
import org.gjt.sp.jedit.search.PatternSearchMatcher;
import org.gjt.sp.jedit.search.SearchDialog;
import org.gjt.sp.jedit.search.SearchFileSet;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ReverseCharSequence;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.TaskManager;
import org.gjt.sp.util.ThreadUtilities;

public class SearchAndReplace {
    private static String search;
    private static String replace;
    private static BshMethod replaceMethod;
    private static NameSpace replaceNS;
    private static boolean regexp;
    private static boolean wholeWord;
    private static boolean ignoreCase;
    private static boolean reverse;
    private static boolean beanshell;
    private static boolean wrap;
    private static SearchMatcher matcher;
    private static SearchFileSet fileset;

    public static void setSearchString(String string) {
        if (string.equals(search)) {
            return;
        }
        search = string;
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static String getSearchString() {
        return search;
    }

    public static void setReplaceString(String string) {
        if (string.equals(replace)) {
            return;
        }
        replace = string;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static String getReplaceString() {
        return replace;
    }

    public static void setWholeWord(boolean bl) {
        if (bl == wholeWord) {
            return;
        }
        wholeWord = bl;
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static void setIgnoreCase(boolean bl) {
        if (bl == ignoreCase) {
            return;
        }
        ignoreCase = bl;
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getWholeWord() {
        return wholeWord;
    }

    public static boolean getIgnoreCase() {
        return ignoreCase;
    }

    public static void setRegexp(boolean bl) {
        if (bl == regexp) {
            return;
        }
        regexp = bl;
        if (bl && reverse) {
            reverse = false;
        }
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getRegexp() {
        return regexp;
    }

    public static void setReverseSearch(boolean bl) {
        if (bl == reverse) {
            return;
        }
        reverse = bl;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getReverseSearch() {
        return reverse;
    }

    public static void setBeanShellReplace(boolean bl) {
        if (bl == beanshell) {
            return;
        }
        beanshell = bl;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getBeanShellReplace() {
        return beanshell;
    }

    public static void setAutoWrapAround(boolean bl) {
        if (bl == wrap) {
            return;
        }
        wrap = bl;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getAutoWrapAround() {
        return wrap;
    }

    public static void setSearchMatcher(SearchMatcher searchMatcher) {
        matcher = searchMatcher;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static SearchMatcher getSearchMatcher() throws Exception {
        if (matcher != null) {
            return matcher;
        }
        if (search == null || "".equals(search)) {
            return null;
        }
        if (regexp) {
            Pattern pattern = Pattern.compile(search, PatternSearchMatcher.getFlag(ignoreCase));
            matcher = new PatternSearchMatcher(pattern, ignoreCase, wholeWord);
        } else {
            matcher = new BoyerMooreSearchMatcher(search, ignoreCase, wholeWord);
        }
        return matcher;
    }

    public static void setSearchFileSet(SearchFileSet searchFileSet) {
        fileset = searchFileSet;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static SearchFileSet getSearchFileSet() {
        return fileset;
    }

    public static boolean getSmartCaseReplace() {
        return replace != null && TextUtilities.getStringCase(replace) == 1;
    }

    public static boolean hyperSearch(View view) {
        return SearchAndReplace.hyperSearch(view, false);
    }

    public static boolean hyperSearch(View view, boolean bl) {
        Window window = SearchDialog.getSearchDialog(view);
        if (window == null) {
            window = view;
        }
        SearchAndReplace.record(view, "hyperSearch(view," + bl + ')', false, !bl);
        view.getDockableWindowManager().addDockableWindow("hypersearch-results");
        HyperSearchResults hyperSearchResults = (HyperSearchResults)view.getDockableWindowManager().getDockable("hypersearch-results");
        hyperSearchResults.searchStarted();
        try {
            Selection[] selectionArray;
            SearchMatcher searchMatcher = SearchAndReplace.getSearchMatcher();
            if (searchMatcher == null) {
                view.getToolkit().beep();
                hyperSearchResults.searchFailed();
                return false;
            }
            if (bl) {
                selectionArray = view.getTextArea().getSelection();
                if (selectionArray == null) {
                    hyperSearchResults.searchFailed();
                    return false;
                }
            } else {
                selectionArray = null;
            }
            ThreadUtilities.runInBackground(new HyperSearchRequest(view, searchMatcher, hyperSearchResults, selectionArray));
            return true;
        }
        catch (Exception exception) {
            hyperSearchResults.searchFailed();
            SearchAndReplace.handleError(window, exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean find(View view) {
        String string;
        Window window = SearchDialog.getSearchDialog(view);
        if (window == null || !((Component)window).isShowing()) {
            window = view;
        }
        if ((string = fileset.getNextFile(view, null)) == null) {
            GUIUtilities.error(window, "empty-fileset", null);
            return false;
        }
        try {
            view.showWaitCursor();
            SearchMatcher searchMatcher = SearchAndReplace.getSearchMatcher();
            if (searchMatcher == null) {
                view.getToolkit().beep();
                boolean bl = false;
                return bl;
            }
            SearchAndReplace.record(view, "find(view)", false, true);
            boolean bl = false;
            while (true) {
                boolean bl2;
                if (string != null) {
                    JEditTextArea jEditTextArea;
                    Selection selection;
                    Buffer buffer = jEdit.openTemporary(view, null, string, false);
                    string = reverse ? fileset.getPrevFile(view, string) : fileset.getNextFile(view, string);
                    if (buffer == null) continue;
                    if (!buffer.isLoaded()) {
                        TaskManager.instance.waitForIoTasks();
                    }
                    int n = view.getBuffer() == buffer && !bl ? ((selection = (jEditTextArea = view.getTextArea()).getSelectionAtOffset(jEditTextArea.getCaretPosition())) == null ? jEditTextArea.getCaretPosition() : (reverse ? selection.getStart() : selection.getEnd())) : (reverse ? buffer.getLength() : 0);
                    if (!SearchAndReplace.find(view, buffer, n, bl, reverse)) continue;
                    boolean bl3 = true;
                    return bl3;
                }
                if (bl) {
                    if (!BeanShell.isScriptRunning()) {
                        view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.search-not-found"));
                        view.getToolkit().beep();
                    }
                    boolean bl4 = false;
                    return bl4;
                }
                if (wrap) {
                    if (!BeanShell.isScriptRunning()) {
                        view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.auto-wrap"));
                        if (jEdit.getBooleanProperty("search.beepOnSearchAutoWrap")) {
                            view.getToolkit().beep();
                        }
                    }
                    bl2 = true;
                } else if (BeanShell.isScriptRunning()) {
                    bl2 = false;
                } else {
                    Object[] objectArray = new Integer[]{reverse ? 1 : 0};
                    int n = GUIUtilities.confirm(window, "keepsearching", objectArray, 0, 3);
                    boolean bl5 = bl2 = n == 0;
                }
                if (bl2) {
                    string = fileset.getFirstFile(view);
                    bl = true;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            SearchAndReplace.handleError(window, exception);
        }
        finally {
            view.hideWaitCursor();
        }
        return false;
    }

    public static boolean find(View view, Buffer buffer, int n) throws Exception {
        return SearchAndReplace.find(view, buffer, n, false, false);
    }

    public static boolean find(View view, Buffer buffer, int n, boolean bl, boolean bl2) throws Exception {
        Object object;
        boolean bl3;
        boolean bl4;
        CharSequence charSequence;
        EditBus.send(new PositionChanging(view.getEditPane()));
        SearchMatcher searchMatcher = SearchAndReplace.getSearchMatcher();
        if (searchMatcher == null) {
            view.getToolkit().beep();
            return false;
        }
        if (bl2) {
            charSequence = new ReverseCharSequence(buffer.getSegment(0, n));
            bl4 = true;
            bl3 = buffer.getLineEndOffset(buffer.getLineOfOffset(n)) - 1 == n;
        } else {
            charSequence = buffer.getSegment(n, buffer.getLength() - n);
            bl4 = buffer.getLineStartOffset(buffer.getLineOfOffset(n)) == n;
            bl3 = true;
        }
        if (searchMatcher.wholeWord) {
            object = buffer.getStringProperty("noWordSep");
            searchMatcher.setNoWordSep((String)object);
        }
        if ((object = searchMatcher.nextMatch(charSequence, bl4, bl3, bl, bl2)) != null) {
            jEdit.commitTemporary(buffer);
            view.setBuffer(buffer);
            JEditTextArea jEditTextArea = view.getTextArea();
            if (bl2) {
                jEditTextArea.setSelection(new Selection.Range(n - ((SearchMatcher.Match)object).end, n - ((SearchMatcher.Match)object).start));
                jEditTextArea.scrollTo(n - ((SearchMatcher.Match)object).start, false);
                jEditTextArea.moveCaretPosition(n - ((SearchMatcher.Match)object).end);
            } else {
                jEditTextArea.setSelection(new Selection.Range(n + ((SearchMatcher.Match)object).start, n + ((SearchMatcher.Match)object).end));
                jEditTextArea.moveCaretPosition(n + ((SearchMatcher.Match)object).end);
                jEditTextArea.scrollTo(n + ((SearchMatcher.Match)object).start, false);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replace(View view) {
        Window window = SearchDialog.getSearchDialog(view);
        if (window == null) {
            window = view;
        }
        JEditTextArea jEditTextArea = view.getTextArea();
        Buffer buffer = view.getBuffer();
        if (!buffer.isEditable()) {
            return false;
        }
        boolean bl = SearchAndReplace.getSmartCaseReplace();
        Selection[] selectionArray = jEditTextArea.getSelection();
        if (selectionArray.length == 0) {
            view.getToolkit().beep();
            return false;
        }
        SearchAndReplace.record(view, "replace(view)", true, false);
        int n = jEditTextArea.getCaretPosition();
        Selection selection = jEditTextArea.getSelectionAtOffset(n);
        if (selection != null) {
            n = selection.getStart();
        }
        try {
            buffer.beginCompoundEdit();
            SearchMatcher searchMatcher = SearchAndReplace.getSearchMatcher();
            if (searchMatcher == null) {
                boolean bl2 = false;
                return bl2;
            }
            SearchAndReplace.initReplace();
            int n2 = 0;
            Object[] objectArray = selectionArray;
            int n3 = objectArray.length;
            for (int i = 0; i < n3; ++i) {
                Selection selection2;
                selection = selection2 = objectArray[i];
                n2 += SearchAndReplace.replaceInSelection(view, jEditTextArea, buffer, searchMatcher, bl, selection);
            }
            if (reverse) {
                jEditTextArea.moveCaretPosition(n);
            } else {
                selection = jEditTextArea.getSelectionAtOffset(jEditTextArea.getCaretPosition());
                if (selection != null) {
                    jEditTextArea.moveCaretPosition(selection.getEnd());
                }
            }
            if (!BeanShell.isScriptRunning()) {
                objectArray = new Object[]{n2, 1};
                view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.replace-all", objectArray));
            }
            if (n2 == 0) {
                view.getToolkit().beep();
                boolean bl3 = false;
                return bl3;
            }
            boolean bl4 = true;
            return bl4;
        }
        catch (Exception exception) {
            SearchAndReplace.handleError(window, exception);
        }
        finally {
            buffer.endCompoundEdit();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replace(View view, Buffer buffer, int n, int n2) {
        if (!buffer.isEditable()) {
            return false;
        }
        Window window = SearchDialog.getSearchDialog(view);
        if (window == null) {
            window = view;
        }
        boolean bl = SearchAndReplace.getSmartCaseReplace();
        try {
            buffer.beginCompoundEdit();
            SearchMatcher searchMatcher = SearchAndReplace.getSearchMatcher();
            if (searchMatcher == null) {
                boolean bl2 = false;
                return bl2;
            }
            SearchAndReplace.initReplace();
            int n3 = 0;
            if ((n3 += SearchAndReplace._replace(view, buffer, searchMatcher, n, n2, bl)) != 0) {
                boolean bl3 = true;
                return bl3;
            }
        }
        catch (Exception exception) {
            SearchAndReplace.handleError(window, exception);
        }
        finally {
            buffer.endCompoundEdit();
        }
        return false;
    }

    public static boolean replaceAll(View view) {
        return SearchAndReplace.replaceAll(view, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replaceAll(View view, boolean bl) {
        Object[] objectArray;
        Window window = SearchDialog.getSearchDialog(view);
        if (window == null) {
            window = view;
        }
        if (fileset.getFileCount(view) == 0) {
            GUIUtilities.error(window, "empty-fileset", null);
            return false;
        }
        SearchAndReplace.record(view, "replaceAll(view)", true, true);
        view.showWaitCursor();
        boolean bl2 = SearchAndReplace.getSmartCaseReplace();
        int n = 0;
        int n2 = 0;
        try {
            objectArray = SearchAndReplace.getSearchMatcher();
            if (objectArray == null) {
                boolean bl3 = false;
                return bl3;
            }
            SearchAndReplace.initReplace();
            String string = fileset.getFirstFile(view);
            while (string != null) {
                Buffer buffer = jEdit.openTemporary(view, null, string, false);
                string = fileset.getNextFile(view, string);
                if (buffer == null) continue;
                if (buffer.isPerformingIO()) {
                    TaskManager.instance.waitForIoTasks();
                }
                if (!buffer.isEditable()) continue;
                int n3 = 0;
                try {
                    buffer.beginCompoundEdit();
                    n3 = SearchAndReplace._replace(view, buffer, (SearchMatcher)objectArray, 0, buffer.getLength(), bl2);
                }
                finally {
                    buffer.endCompoundEdit();
                }
                if (n3 == 0) continue;
                ++n;
                n2 += n3;
                if (bl) {
                    buffer.save(null, null);
                    continue;
                }
                jEdit.commitTemporary(buffer);
                jEdit.getBufferSetManager().addBuffer(view, buffer);
            }
        }
        catch (Exception exception) {
            SearchAndReplace.handleError(window, exception);
        }
        finally {
            view.hideWaitCursor();
        }
        if (!BeanShell.isScriptRunning()) {
            objectArray = new Object[]{n2, n};
            view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.replace-all", objectArray));
            if (n2 == 0) {
                view.getToolkit().beep();
            }
        }
        return n != 0;
    }

    public static String escapeRegexp(String string, boolean bl) {
        return StandardUtilities.charsToEscapes(string, "\r\t\\()[]{}$^*+?|." + (bl ? "" : "\n"));
    }

    public static void load() {
        search = jEdit.getProperty("search.find.value");
        replace = jEdit.getProperty("search.replace.value");
        wholeWord = jEdit.getBooleanProperty("search.wholeWord.toggle");
        ignoreCase = jEdit.getBooleanProperty("search.ignoreCase.toggle");
        regexp = jEdit.getBooleanProperty("search.regexp.toggle");
        beanshell = jEdit.getBooleanProperty("search.beanshell.toggle");
        wrap = jEdit.getBooleanProperty("search.wrap.toggle");
        fileset = new CurrentBufferSet();
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static void save() {
        jEdit.setProperty("search.find.value", search);
        jEdit.setProperty("search.replace.value", replace);
        jEdit.setBooleanProperty("search.wholeWord.toggle", wholeWord);
        jEdit.setBooleanProperty("search.ignoreCase.toggle", ignoreCase);
        jEdit.setBooleanProperty("search.regexp.toggle", regexp);
        jEdit.setBooleanProperty("search.beanshell.toggle", beanshell);
        jEdit.setBooleanProperty("search.wrap.toggle", wrap);
    }

    static void handleError(Component component, Exception exception) {
        Log.log(9, SearchAndReplace.class, exception);
        if (component instanceof Dialog) {
            new TextAreaDialog((Dialog)component, beanshell ? "searcherror-bsh" : "searcherror", (Throwable)exception);
        } else {
            new TextAreaDialog((Frame)component, beanshell ? "searcherror-bsh" : "searcherror", (Throwable)exception);
        }
    }

    private static void initReplace() throws Exception {
        if (beanshell && replace.length() != 0) {
            String string = replace.trim().startsWith("{") ? replace : "return (" + replace + ");";
            replaceMethod = BeanShell.cacheBlock("replace", string, true);
        } else {
            replaceMethod = null;
        }
    }

    private static void record(View view, String string, boolean bl, boolean bl2) {
        Macros.Recorder recorder = view.getMacroRecorder();
        if (recorder != null) {
            recorder.record("SearchAndReplace.setSearchString(\"" + StandardUtilities.charsToEscapes(search) + "\");");
            if (bl) {
                recorder.record("SearchAndReplace.setReplaceString(\"" + StandardUtilities.charsToEscapes(replace) + "\");");
                recorder.record("SearchAndReplace.setBeanShellReplace(" + beanshell + ");");
            } else {
                recorder.record("SearchAndReplace.setAutoWrapAround(" + wrap + ");");
                recorder.record("SearchAndReplace.setReverseSearch(" + reverse + ");");
            }
            recorder.record("SearchAndReplace.setWholeWord(" + wholeWord + ");");
            recorder.record("SearchAndReplace.setIgnoreCase(" + ignoreCase + ");");
            recorder.record("SearchAndReplace.setRegexp(" + regexp + ");");
            if (bl2) {
                recorder.record("SearchAndReplace.setSearchFileSet(" + fileset.getCode() + ");");
            }
            recorder.record("SearchAndReplace." + string + ';');
        }
    }

    private static int replaceInSelection(View view, TextArea textArea, Buffer buffer, SearchMatcher searchMatcher, boolean bl, Selection selection) throws Exception {
        int n;
        int n2 = selection.getStart();
        if (selection instanceof Selection.Range) {
            n = SearchAndReplace._replace(view, buffer, searchMatcher, selection.getStart(), selection.getEnd(), bl);
            textArea.removeFromSelection(selection);
            textArea.addToSelection(new Selection.Range(n2, selection.getEnd()));
        } else if (selection instanceof Selection.Rect) {
            Selection.Rect rect = (Selection.Rect)selection;
            int n3 = rect.getStartColumn(buffer);
            int n4 = rect.getEndColumn(buffer);
            n = 0;
            for (int i = selection.getStartLine(); i <= selection.getEndLine(); ++i) {
                n += SearchAndReplace._replace(view, buffer, searchMatcher, SearchAndReplace.getColumnOnOtherLine(buffer, i, n3), SearchAndReplace.getColumnOnOtherLine(buffer, i, n4), bl);
            }
            textArea.addToSelection(new Selection.Rect(n2, selection.getEnd()));
        } else {
            throw new RuntimeException("Unsupported: " + selection);
        }
        return n;
    }

    private static int _replace(View view, JEditBuffer jEditBuffer, SearchMatcher searchMatcher, int n, int n2, boolean bl) throws Exception {
        if (searchMatcher.wholeWord) {
            String string = jEditBuffer.getStringProperty("noWordSep");
            searchMatcher.setNoWordSep(string);
        }
        int n3 = 0;
        boolean bl2 = jEditBuffer.getLineEndOffset(jEditBuffer.getLineOfOffset(n2)) - 1 == n2;
        int n4 = n;
        int n5 = 0;
        while (true) {
            boolean bl3 = jEditBuffer.getLineStartOffset(jEditBuffer.getLineOfOffset(n4)) == n4;
            CharSequence charSequence = jEditBuffer.getSegment(n4, n2 - n4);
            SearchMatcher.Match match = searchMatcher.nextMatch(charSequence, bl3, bl2, n5 == 0, false);
            if (match == null) break;
            CharSequence charSequence2 = charSequence.subSequence(match.start, match.end);
            int n6 = SearchAndReplace.replaceOne(view, jEditBuffer, match, n4, charSequence2, bl);
            if (n6 == -1) {
                n4 += match.end;
            } else {
                n4 += match.start + n6;
                n2 += n6 - charSequence2.length();
                ++n3;
            }
            ++n5;
        }
        return n3;
    }

    private static int replaceOne(View view, JEditBuffer jEditBuffer, SearchMatcher.Match match, int n, CharSequence charSequence, boolean bl) throws Exception {
        int n2;
        String string = SearchAndReplace.replaceOne(view, jEditBuffer, match, charSequence);
        if (bl && ignoreCase) {
            n2 = TextUtilities.getStringCase(charSequence);
            if (n2 == 1) {
                string = string.toLowerCase();
            } else if (n2 == 2) {
                string = string.toUpperCase();
            } else if (n2 == 3) {
                string = TextUtilities.toTitleCase(string);
            }
        }
        if (string != null) {
            int n3 = n + match.end;
            n2 = n + match.start;
            if (n3 - n2 > 0) {
                jEditBuffer.remove(n2, n3 - n2);
            }
            jEditBuffer.insert(n2, string);
            return string.length();
        }
        return -1;
    }

    private static String replaceOne(View view, JEditBuffer jEditBuffer, SearchMatcher.Match match, CharSequence charSequence) throws Exception {
        if (regexp) {
            if (replaceMethod != null) {
                return SearchAndReplace.regexpBeanShellReplace(view, jEditBuffer, match);
            }
            return SearchAndReplace.regexpReplace(match, charSequence);
        }
        if (replaceMethod != null) {
            return SearchAndReplace.literalBeanShellReplace(view, jEditBuffer, charSequence);
        }
        return replace;
    }

    private static String regexpBeanShellReplace(View view, JEditBuffer jEditBuffer, SearchMatcher.Match match) throws Exception {
        replaceNS.setVariable("buffer", jEditBuffer, false);
        for (int i = 0; i < match.substitutions.length; ++i) {
            replaceNS.setVariable("_" + i, match.substitutions[i]);
        }
        Object object = BeanShell.runCachedBlock(replaceMethod, view, replaceNS);
        for (int i = 0; i < match.substitutions.length; ++i) {
            replaceNS.setVariable("_" + i, null, false);
        }
        replaceNS.setVariable("buffer", null, false);
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    private static String regexpReplace(SearchMatcher.Match match, CharSequence charSequence) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        block8: for (int i = 0; i < replace.length(); ++i) {
            char c = replace.charAt(i);
            switch (c) {
                case '$': {
                    String string;
                    if (i == replace.length() - 1) {
                        stringBuilder.append(c);
                        continue block8;
                    }
                    if ((c = replace.charAt(++i)) == '$') {
                        stringBuilder.append('$');
                        continue block8;
                    }
                    if (c == '0') {
                        stringBuilder.append(charSequence);
                        continue block8;
                    }
                    if (!Character.isDigit(c)) continue block8;
                    int n = c - 48;
                    while (i < replace.length() - 1) {
                        if (Character.isDigit(c = replace.charAt(++i))) {
                            n = n * 10 + (c - 48);
                            continue;
                        }
                        --i;
                        break;
                    }
                    if (n >= match.substitutions.length || (string = match.substitutions[n]) == null) continue block8;
                    stringBuilder.append(string);
                    continue block8;
                }
                case '\\': {
                    if (i == replace.length() - 1) {
                        stringBuilder.append('\\');
                        continue block8;
                    }
                    c = replace.charAt(++i);
                    switch (c) {
                        case 'n': {
                            stringBuilder.append('\n');
                            continue block8;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            continue block8;
                        }
                    }
                    stringBuilder.append(c);
                    continue block8;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static String literalBeanShellReplace(View view, JEditBuffer jEditBuffer, CharSequence charSequence) throws Exception {
        replaceNS.setVariable("buffer", jEditBuffer);
        replaceNS.setVariable("_0", charSequence);
        Object object = BeanShell.runCachedBlock(replaceMethod, view, replaceNS);
        replaceNS.setVariable("_0", null, false);
        replaceNS.setVariable("buffer", null, false);
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    private static int getColumnOnOtherLine(Buffer buffer, int n, int n2) {
        int n3 = buffer.getOffsetOfVirtualColumn(n, n2, null);
        if (n3 == -1) {
            return buffer.getLineEndOffset(n) - 1;
        }
        return buffer.getLineStartOffset(n) + n3;
    }

    static {
        replaceNS = new NameSpace(BeanShell.getNameSpace(), BeanShell.getNameSpace().getClassManager(), "search and replace");
    }
}

