/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.common;

import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;

public final class XMLUtils {
    private XMLUtils() {
    }

    public static String nullSafeGetStringAttribute(Node node, String attributeName) {
        Node namedItem;
        if (node != null && (namedItem = node.getAttributes().getNamedItem(attributeName)) != null) {
            return namedItem.getNodeValue();
        }
        return null;
    }

    public static boolean nullSafeGetBooleanAttribute(Node node, String attributeName) {
        return XMLUtils.nullSafeGetBooleanAttribute(node, attributeName, false);
    }

    public static boolean nullSafeGetBooleanAttribute(Node node, String attributeName, boolean defaultValue) {
        String value = XMLUtils.nullSafeGetStringAttribute(node, attributeName);
        if (StringUtils.isNotBlank(value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }
}

