/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.cos;

import java.io.IOException;
import java.math.BigDecimal;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.cos.COSVisitor;

public class COSFloat
extends COSNumber {
    private BigDecimal value;

    public COSFloat(float aFloat) {
        this.value = new BigDecimal(String.valueOf(aFloat));
    }

    public COSFloat(String aFloat) throws IOException {
        try {
            this.value = new BigDecimal(aFloat);
        }
        catch (NumberFormatException e) {
            if (aFloat.startsWith("0.00000-")) {
                try {
                    this.value = new BigDecimal(aFloat.substring(8));
                }
                catch (NumberFormatException e2) {
                    throw new IOException("Error expected floating point number actual='" + aFloat + "'", e2);
                }
            }
            throw new IOException("Error expected floating point number actual='" + aFloat + "'", e);
        }
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    public boolean equals(Object o) {
        return o instanceof COSFloat && Float.floatToIntBits(((COSFloat)o).value.floatValue()) == Float.floatToIntBits(this.value.floatValue());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.stripTrailingZeros().toPlainString();
    }

    @Override
    public void accept(COSVisitor visitor) throws IOException {
        visitor.visit(this);
    }
}

