'use strict';
var updateNotifier = require('./');
var options = JSON.parse(process.argv[2]);
var updateNotifier = new updateNotifier.UpdateNotifier(options);

updateNotifier.checkNpm(function (err, update) {
	if (err) {
		process.exit(1);
	}

	// only update the last update check time on success
	updateNotifier.config.set('lastUpdateCheck', Date.now());

	if (update.type && update.type !== 'latest') {
		updateNotifier.config.set('update', update);
	}

	// Call process exit explicitly to terminate the child process
	// Otherwise the child process will run forever (according to nodejs docs)
	process.exit();
});
