/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.io.File;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.parosproxy.paros.db.Database;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DatabaseListener;
import org.parosproxy.paros.db.DatabaseServer;
import org.parosproxy.paros.db.DatabaseUnsupportedException;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.db.TableContext;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.db.TableParam;
import org.parosproxy.paros.db.TableScan;
import org.parosproxy.paros.db.TableSession;
import org.parosproxy.paros.db.TableSessionUrl;
import org.parosproxy.paros.db.TableStructure;
import org.parosproxy.paros.db.TableTag;
import org.parosproxy.paros.db.paros.ParosDatabaseServer;
import org.parosproxy.paros.db.paros.ParosTableAlert;
import org.parosproxy.paros.db.paros.ParosTableContext;
import org.parosproxy.paros.db.paros.ParosTableHistory;
import org.parosproxy.paros.db.paros.ParosTableParam;
import org.parosproxy.paros.db.paros.ParosTableScan;
import org.parosproxy.paros.db.paros.ParosTableSession;
import org.parosproxy.paros.db.paros.ParosTableSessionUrl;
import org.parosproxy.paros.db.paros.ParosTableStructure;
import org.parosproxy.paros.db.paros.ParosTableTag;

public class ParosDatabase
implements Database {
    private ParosDatabaseServer databaseServer = null;
    private TableHistory tableHistory = null;
    private TableSession tableSession = null;
    private TableAlert tableAlert = null;
    private TableScan tableScan = null;
    private TableTag tableTag = null;
    private TableSessionUrl tableSessionUrl = null;
    private TableParam tableParam = null;
    private TableContext tableContext = null;
    private TableStructure tableStructure = null;
    private static final Logger log = Logger.getLogger(ParosDatabase.class);
    private Vector<DatabaseListener> listenerList = new Vector();

    public ParosDatabase() {
        this.tableHistory = new ParosTableHistory();
        this.tableSession = new ParosTableSession();
        this.tableAlert = new ParosTableAlert();
        this.tableScan = new ParosTableScan();
        this.tableTag = new ParosTableTag();
        this.tableSessionUrl = new ParosTableSessionUrl();
        this.tableParam = new ParosTableParam();
        this.tableContext = new ParosTableContext();
        this.tableStructure = new ParosTableStructure();
        this.addDatabaseListener(this.tableHistory);
        this.addDatabaseListener(this.tableSession);
        this.addDatabaseListener(this.tableAlert);
        this.addDatabaseListener(this.tableScan);
        this.addDatabaseListener(this.tableTag);
        this.addDatabaseListener(this.tableSessionUrl);
        this.addDatabaseListener(this.tableParam);
        this.addDatabaseListener(this.tableContext);
        this.addDatabaseListener(this.tableStructure);
    }

    @Override
    public DatabaseServer getDatabaseServer() {
        return this.databaseServer;
    }

    private void setDatabaseServer(ParosDatabaseServer parosDatabaseServer) {
        this.databaseServer = parosDatabaseServer;
    }

    @Override
    public TableHistory getTableHistory() {
        return this.tableHistory;
    }

    @Override
    public TableSession getTableSession() {
        return this.tableSession;
    }

    @Override
    public void addDatabaseListener(DatabaseListener databaseListener) {
        this.listenerList.add(databaseListener);
    }

    @Override
    public void removeDatabaseListener(DatabaseListener databaseListener) {
        this.listenerList.remove(databaseListener);
    }

    private void notifyListenerDatabaseOpen() throws DatabaseException {
        DatabaseListener databaseListener = null;
        for (int i = 0; i < this.listenerList.size(); ++i) {
            databaseListener = this.listenerList.get(i);
            try {
                databaseListener.databaseOpen(this.getDatabaseServer());
                continue;
            }
            catch (DatabaseUnsupportedException databaseUnsupportedException) {
                log.error((Object)databaseUnsupportedException.getMessage(), (Throwable)databaseUnsupportedException);
            }
        }
    }

    @Override
    public void open(String string) throws ClassNotFoundException, Exception {
        log.debug((Object)("open " + string));
        this.setDatabaseServer(new ParosDatabaseServer(string));
        this.notifyListenerDatabaseOpen();
    }

    @Override
    public void close(boolean bl) {
        this.close(bl, true);
    }

    @Override
    public void deleteSession(String string) {
        log.debug((Object)("deleteSession " + string));
        if (this.databaseServer == null) {
            return;
        }
        try {
            this.databaseServer.shutdown(false);
        }
        catch (SQLException sQLException) {
            log.error((Object)sQLException.getMessage(), (Throwable)sQLException);
        }
        this.deleteDbFile(new File(string));
        this.deleteDbFile(new File(string + ".data"));
        this.deleteDbFile(new File(string + ".script"));
        this.deleteDbFile(new File(string + ".properties"));
        this.deleteDbFile(new File(string + ".backup"));
        this.deleteDbFile(new File(string + ".lobs"));
        this.databaseServer = null;
    }

    private void deleteDbFile(File file) {
        log.debug((Object)("Deleting " + file.getAbsolutePath()));
        if (file.exists() && !file.delete()) {
            log.error((Object)("Failed to delete " + file.getAbsolutePath()));
        }
    }

    @Override
    public void close(boolean bl, boolean bl2) {
        log.debug((Object)"close");
        if (this.databaseServer == null) {
            return;
        }
        try {
            if (bl2) {
                this.getTableHistory().deleteTemporary();
            }
            this.databaseServer.shutdown(bl);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public TableAlert getTableAlert() {
        return this.tableAlert;
    }

    @Override
    public void setTableAlert(TableAlert tableAlert) {
        this.tableAlert = tableAlert;
    }

    @Override
    public TableScan getTableScan() {
        return this.tableScan;
    }

    @Override
    public void setTableScan(TableScan tableScan) {
        this.tableScan = tableScan;
    }

    @Override
    public TableTag getTableTag() {
        return this.tableTag;
    }

    @Override
    public void setTableTag(TableTag tableTag) {
        this.tableTag = tableTag;
    }

    @Override
    public TableSessionUrl getTableSessionUrl() {
        return this.tableSessionUrl;
    }

    @Override
    public void setTableSessionUrl(TableSessionUrl tableSessionUrl) {
        this.tableSessionUrl = tableSessionUrl;
    }

    @Override
    public TableParam getTableParam() {
        return this.tableParam;
    }

    @Override
    public TableContext getTableContext() {
        return this.tableContext;
    }

    @Override
    public TableStructure getTableStructure() {
        return this.tableStructure;
    }

    @Override
    public String getType() {
        return "hsqldb";
    }
}

