/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SortOrder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.pscan.DialogAddAutoTagScanner;
import org.zaproxy.zap.extension.pscan.DialogModifyAutoTagScanner;
import org.zaproxy.zap.extension.pscan.OptionsPassiveScanTableModel;
import org.zaproxy.zap.extension.pscan.PassiveScanParam;
import org.zaproxy.zap.extension.pscan.PassiveScannerList;
import org.zaproxy.zap.extension.pscan.scanner.RegexAutoTagScanner;
import org.zaproxy.zap.view.AbstractMultipleOptionsTablePanel;

public class OptionsPassiveScan
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private PassiveScannerList passiveScanners = null;
    private ScannersMultipleOptionsPanel scannersOptionsPanel;
    private OptionsPassiveScanTableModel tableModel = null;

    public OptionsPassiveScan(PassiveScannerList passiveScannerList) {
        this.passiveScanners = passiveScannerList;
        this.initialize();
    }

    private void initialize() {
        this.setName(Constant.messages.getString("pscan.options.name"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        this.add((Component)new JLabel(Constant.messages.getString("pscan.options.header")), gridBagConstraints);
        this.scannersOptionsPanel = new ScannersMultipleOptionsPanel(this.getTableModel());
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scannersOptionsPanel, gridBagConstraints);
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        PassiveScanParam passiveScanParam = optionsParam.getParamSet(PassiveScanParam.class);
        this.getTableModel().setScanDefns(passiveScanParam.getAutoTagScanners());
        this.scannersOptionsPanel.setRemoveWithoutConfirmation(!passiveScanParam.isConfirmRemoveAutoTagScanner());
    }

    @Override
    public void validateParam(Object object) throws Exception {
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        PassiveScanParam passiveScanParam = optionsParam.getParamSet(PassiveScanParam.class);
        passiveScanParam.setAutoTagScanners(this.getTableModel().getElements());
        passiveScanParam.setConfirmRemoveAutoTagScanner(!this.scannersOptionsPanel.isRemoveWithoutConfirmation());
        this.passiveScanners.setAutoTagScanners(passiveScanParam.getAutoTagScanners());
    }

    private OptionsPassiveScanTableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new OptionsPassiveScanTableModel();
        }
        return this.tableModel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.pscan";
    }

    private static class ScannersMultipleOptionsPanel
    extends AbstractMultipleOptionsTablePanel<RegexAutoTagScanner> {
        private static final long serialVersionUID = 8762085355395403532L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("pscan.options.dialog.scanner.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("pscan.options.dialog.scanner.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("pscan.options.dialog.scanner.remove.button.confirm");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("pscan.options.dialog.scanner.remove.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("pscan.options.dialog.scanner.remove.checkbox.label");
        private DialogAddAutoTagScanner addDialog = null;
        private DialogModifyAutoTagScanner modifyDialog = null;
        private OptionsPassiveScanTableModel model;

        public ScannersMultipleOptionsPanel(OptionsPassiveScanTableModel optionsPassiveScanTableModel) {
            super(optionsPassiveScanTableModel);
            this.model = optionsPassiveScanTableModel;
            this.getTable().getColumnExt(0).setPreferredWidth(20);
            this.getTable().setSortOrder(1, SortOrder.ASCENDING);
        }

        @Override
        public RegexAutoTagScanner showAddDialogue() {
            if (this.addDialog == null) {
                this.addDialog = new DialogAddAutoTagScanner(View.getSingleton().getOptionsDialog(null));
                this.addDialog.pack();
            }
            this.addDialog.setScanners(this.model.getElements());
            this.addDialog.setVisible(true);
            RegexAutoTagScanner regexAutoTagScanner = this.addDialog.getScanner();
            this.addDialog.clear();
            return regexAutoTagScanner;
        }

        @Override
        public RegexAutoTagScanner showModifyDialogue(RegexAutoTagScanner regexAutoTagScanner) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new DialogModifyAutoTagScanner(View.getSingleton().getOptionsDialog(null));
                this.modifyDialog.pack();
            }
            this.modifyDialog.setScanners(this.model.getElements());
            this.modifyDialog.setApp(regexAutoTagScanner);
            this.modifyDialog.setVisible(true);
            RegexAutoTagScanner regexAutoTagScanner2 = this.modifyDialog.getScanner();
            this.modifyDialog.clear();
            if (!regexAutoTagScanner2.equals(regexAutoTagScanner)) {
                return regexAutoTagScanner2;
            }
            return null;
        }

        @Override
        public boolean showRemoveDialogue(RegexAutoTagScanner regexAutoTagScanner) {
            JCheckBox jCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] objectArray = new Object[]{REMOVE_DIALOG_TEXT, " ", jCheckBox};
            int n = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), objectArray, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (n == 0) {
                this.setRemoveWithoutConfirmation(jCheckBox.isSelected());
                return true;
            }
            return false;
        }
    }
}

