/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestToXContentListener;

public class BulkIndexByScrollResponseContentListener<R extends BulkIndexByScrollResponse>
extends RestToXContentListener<R> {
    public BulkIndexByScrollResponseContentListener(RestChannel channel) {
        super(channel);
    }

    protected RestStatus getStatus(R response) {
        RestStatus status = RestStatus.OK;
        if (((BulkIndexByScrollResponse)((Object)response)).isTimedOut()) {
            status = RestStatus.REQUEST_TIMEOUT;
        }
        for (BulkItemResponse.Failure failure : ((BulkIndexByScrollResponse)((Object)response)).getIndexingFailures()) {
            if (failure.getStatus().getStatus() <= status.getStatus()) continue;
            status = failure.getStatus();
        }
        for (ShardSearchFailure shardSearchFailure : ((BulkIndexByScrollResponse)((Object)response)).getSearchFailures()) {
            RestStatus failureStatus = ExceptionsHelper.status((Throwable)shardSearchFailure.getCause());
            if (failureStatus.getStatus() <= status.getStatus()) continue;
            status = failureStatus;
        }
        return status;
    }
}

