/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import org.elasticsearch.cluster.AbstractAckedClusterStateTaskListener;
import org.elasticsearch.cluster.AbstractClusterStateTaskListener;
import org.elasticsearch.cluster.BasicClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidTypeNameException;

public class MetaDataMappingService
extends AbstractComponent {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    final ClusterStateTaskExecutor<RefreshTask> refreshExecutor = new RefreshTaskExecutor();
    final ClusterStateTaskExecutor<PutMappingClusterStateUpdateRequest> putMappingExecutor = new PutMappingExecutor();

    @Inject
    public MetaDataMappingService(Settings settings, ClusterService clusterService, IndicesService indicesService) {
        super(settings);
        this.clusterService = clusterService;
        this.indicesService = indicesService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterState executeRefresh(ClusterState currentState, List<RefreshTask> allTasks) throws Exception {
        HashMap<String, ArrayList<RefreshTask>> tasksPerIndex = new HashMap<String, ArrayList<RefreshTask>>();
        for (RefreshTask refreshTask : allTasks) {
            ArrayList<RefreshTask> indexTasks;
            if (refreshTask.index == null) {
                this.logger.debug("ignoring a mapping task of type [{}] with a null index.", refreshTask);
            }
            if ((indexTasks = (ArrayList<RefreshTask>)tasksPerIndex.get(refreshTask.index)) == null) {
                indexTasks = new ArrayList<RefreshTask>();
                tasksPerIndex.put(refreshTask.index, indexTasks);
            }
            indexTasks.add(refreshTask);
        }
        boolean dirty = false;
        MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
        for (Map.Entry entry : tasksPerIndex.entrySet()) {
            String index = (String)entry.getKey();
            IndexMetaData indexMetaData = mdBuilder.get(index);
            if (indexMetaData == null) {
                this.logger.debug("[{}] ignoring tasks - index meta data doesn't exist", index);
                continue;
            }
            List allIndexTasks = (List)entry.getValue();
            boolean hasTaskWithRightUUID = false;
            for (RefreshTask task : allIndexTasks) {
                if (indexMetaData.isSameUUID(task.indexUUID)) {
                    hasTaskWithRightUUID = true;
                    continue;
                }
                this.logger.debug("[{}] ignoring task [{}] - index meta data doesn't match task uuid", index, task);
            }
            if (!hasTaskWithRightUUID) continue;
            boolean removeIndex = false;
            IndexService indexService = this.indicesService.indexService(index);
            if (indexService == null) {
                indexService = this.indicesService.createIndex(indexMetaData.getIndex(), indexMetaData.getSettings(), currentState.nodes().localNode().id());
                removeIndex = true;
                for (ObjectCursor metaData : indexMetaData.getMappings().values()) {
                    indexService.mapperService().merge(((MappingMetaData)metaData.value).type(), ((MappingMetaData)metaData.value).source(), MapperService.MergeReason.MAPPING_RECOVERY, true);
                }
            }
            IndexMetaData.Builder builder = IndexMetaData.builder(indexMetaData);
            try {
                boolean indexDirty = this.refreshIndexMapping(indexService, builder);
                if (!indexDirty) continue;
                mdBuilder.put(builder);
                dirty = true;
            }
            finally {
                if (!removeIndex) continue;
                this.indicesService.removeIndex(index, "created for mapping processing");
            }
        }
        if (!dirty) {
            return currentState;
        }
        return ClusterState.builder(currentState).metaData(mdBuilder).build();
    }

    private boolean refreshIndexMapping(IndexService indexService, IndexMetaData.Builder builder) {
        boolean dirty = false;
        String index = indexService.index().name();
        try {
            ArrayList<String> updatedTypes = new ArrayList<String>();
            for (DocumentMapper mapper : indexService.mapperService().docMappers(true)) {
                String type = mapper.type();
                if (mapper.mappingSource().equals(builder.mapping(type).source())) continue;
                updatedTypes.add(type);
            }
            if (!updatedTypes.isEmpty()) {
                this.logger.warn("[{}] re-syncing mappings with cluster state because of types [{}]", index, updatedTypes);
                dirty = true;
                for (DocumentMapper mapper : indexService.mapperService().docMappers(true)) {
                    builder.putMapping(new MappingMetaData(mapper));
                }
            }
        }
        catch (Throwable t) {
            this.logger.warn("[{}] failed to refresh-mapping in cluster state", t, index);
        }
        return dirty;
    }

    public void refreshMapping(String index, String indexUUID) {
        RefreshTask refreshTask = new RefreshTask(index, indexUUID);
        this.clusterService.submitStateUpdateTask("refresh-mapping [" + index + "]", refreshTask, BasicClusterStateTaskConfig.create(Priority.HIGH), this.refreshExecutor, new AbstractClusterStateTaskListener(){

            @Override
            public void onFailure(String source, Throwable t) {
                MetaDataMappingService.this.logger.warn("failure during [{}]", t, source);
            }
        });
    }

    public void putMapping(final PutMappingClusterStateUpdateRequest request, final ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("put-mapping [" + request.type() + "]", request, BasicClusterStateTaskConfig.create(Priority.HIGH, request.masterNodeTimeout()), this.putMappingExecutor, new AbstractAckedClusterStateTaskListener(){

            @Override
            public void onFailure(String source, Throwable t) {
                listener.onFailure(t);
            }

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return true;
            }

            @Override
            public void onAllNodesAcked(@Nullable Throwable t) {
                listener.onResponse(new ClusterStateUpdateResponse(true));
            }

            @Override
            public void onAckTimeout() {
                listener.onResponse(new ClusterStateUpdateResponse(false));
            }

            @Override
            public TimeValue ackTimeout() {
                return request.ackTimeout();
            }
        });
    }

    class PutMappingExecutor
    extends ClusterStateTaskExecutor<PutMappingClusterStateUpdateRequest> {
        PutMappingExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClusterStateTaskExecutor.BatchResult<PutMappingClusterStateUpdateRequest> execute(ClusterState currentState, List<PutMappingClusterStateUpdateRequest> tasks) throws Exception {
            HashSet<String> indicesToClose = new HashSet<String>();
            ClusterStateTaskExecutor.BatchResult.Builder<PutMappingClusterStateUpdateRequest> builder = ClusterStateTaskExecutor.BatchResult.builder();
            try {
                for (PutMappingClusterStateUpdateRequest request : tasks) {
                    for (String index : request.indices()) {
                        IndexMetaData indexMetaData = currentState.metaData().index(index);
                        if (indexMetaData == null || MetaDataMappingService.this.indicesService.hasIndex(index)) continue;
                        indicesToClose.add(index);
                        IndexService indexService = MetaDataMappingService.this.indicesService.createIndex(indexMetaData.getIndex(), indexMetaData.getSettings(), MetaDataMappingService.this.clusterService.localNode().id());
                        for (ObjectCursor mapping : indexMetaData.getMappings().values()) {
                            indexService.mapperService().merge(((MappingMetaData)mapping.value).type(), ((MappingMetaData)mapping.value).source(), MapperService.MergeReason.MAPPING_RECOVERY, request.updateAllTypes());
                        }
                    }
                }
                for (PutMappingClusterStateUpdateRequest request : tasks) {
                    try {
                        currentState = this.applyRequest(currentState, request);
                        builder.success(request);
                    }
                    catch (Throwable t) {
                        builder.failure(request, t);
                    }
                }
                ClusterStateTaskExecutor.BatchResult<PutMappingClusterStateUpdateRequest> batchResult = builder.build(currentState);
                return batchResult;
            }
            finally {
                for (String index : indicesToClose) {
                    MetaDataMappingService.this.indicesService.removeIndex(index, "created for mapping processing");
                }
            }
        }

        private ClusterState applyRequest(ClusterState currentState, PutMappingClusterStateUpdateRequest request) throws IOException {
            String mappingType = request.type();
            CompressedXContent mappingUpdateSource = new CompressedXContent(request.source());
            for (String index : request.indices()) {
                DocumentMapper newMapper;
                IndexService indexService = MetaDataMappingService.this.indicesService.indexServiceSafe(index);
                DocumentMapper existingMapper = indexService.mapperService().documentMapper(request.type());
                if ("_default_".equals(request.type())) {
                    newMapper = indexService.mapperService().parse(request.type(), mappingUpdateSource, false);
                } else {
                    newMapper = indexService.mapperService().parse(request.type(), mappingUpdateSource, existingMapper == null);
                    if (existingMapper != null) {
                        existingMapper.merge(newMapper.mapping(), request.updateAllTypes());
                    } else if (Version.indexCreated(indexService.indexSettings()).onOrAfter(Version.V_2_0_0_beta1) && newMapper.parentFieldMapper().active()) {
                        IndexMetaData indexMetaData = currentState.metaData().index(index);
                        for (ObjectCursor mapping : indexMetaData.getMappings().values()) {
                            if (!newMapper.parentFieldMapper().type().equals(((MappingMetaData)mapping.value).type())) continue;
                            throw new IllegalArgumentException("can't add a _parent field that points to an already existing type");
                        }
                    }
                }
                if (mappingType == null) {
                    mappingType = newMapper.type();
                    continue;
                }
                if (mappingType.equals(newMapper.type())) continue;
                throw new InvalidTypeNameException("Type name provided does not match type name within mapping definition");
            }
            assert (mappingType != null);
            if (!"_default_".equals(mappingType) && !".percolator".equals(mappingType) && mappingType.charAt(0) == '_') {
                throw new InvalidTypeNameException("Document mapping type name can't start with '_'");
            }
            MetaData.Builder builder = MetaData.builder(currentState.metaData());
            for (String index : request.indices()) {
                IndexMetaData indexMetaData;
                IndexService indexService = MetaDataMappingService.this.indicesService.indexService(index);
                if (indexService == null) continue;
                CompressedXContent existingSource = null;
                DocumentMapper existingMapper = indexService.mapperService().documentMapper(mappingType);
                if (existingMapper != null) {
                    existingSource = existingMapper.mappingSource();
                }
                DocumentMapper mergedMapper = indexService.mapperService().merge(mappingType, mappingUpdateSource, MapperService.MergeReason.MAPPING_UPDATE, request.updateAllTypes());
                CompressedXContent updatedSource = mergedMapper.mappingSource();
                if (existingSource != null) {
                    if (!existingSource.equals(updatedSource)) {
                        if (MetaDataMappingService.this.logger.isDebugEnabled()) {
                            MetaDataMappingService.this.logger.debug("[{}] update_mapping [{}] with source [{}]", index, mergedMapper.type(), updatedSource);
                        } else if (MetaDataMappingService.this.logger.isInfoEnabled()) {
                            MetaDataMappingService.this.logger.info("[{}] update_mapping [{}]", index, mergedMapper.type());
                        }
                    }
                } else if (MetaDataMappingService.this.logger.isDebugEnabled()) {
                    MetaDataMappingService.this.logger.debug("[{}] create_mapping [{}] with source [{}]", index, mappingType, updatedSource);
                } else if (MetaDataMappingService.this.logger.isInfoEnabled()) {
                    MetaDataMappingService.this.logger.info("[{}] create_mapping [{}]", index, mappingType);
                }
                if ((indexMetaData = currentState.metaData().index(index)) == null) {
                    throw new IndexNotFoundException(index);
                }
                IndexMetaData.Builder indexMetaDataBuilder = IndexMetaData.builder(indexMetaData);
                for (DocumentMapper mapper : indexService.mapperService().docMappers(true)) {
                    indexMetaDataBuilder.putMapping(new MappingMetaData(mapper.mappingSource()));
                }
                builder.put(indexMetaDataBuilder);
            }
            return ClusterState.builder(currentState).metaData(builder).build();
        }
    }

    class RefreshTaskExecutor
    extends ClusterStateTaskExecutor<RefreshTask> {
        RefreshTaskExecutor() {
        }

        @Override
        public ClusterStateTaskExecutor.BatchResult<RefreshTask> execute(ClusterState currentState, List<RefreshTask> tasks) throws Exception {
            ClusterState newClusterState = MetaDataMappingService.this.executeRefresh(currentState, tasks);
            return ClusterStateTaskExecutor.BatchResult.builder().successes(tasks).build(newClusterState);
        }
    }

    static class RefreshTask {
        final String index;
        final String indexUUID;

        RefreshTask(String index, String indexUUID) {
            this.index = index;
            this.indexUUID = indexUUID;
        }
    }
}

