/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import com.google.common.collect.ImmutableMap;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.analysis.SnowballAnalyzer;
import org.elasticsearch.index.settings.IndexSettingsService;

public class SnowballAnalyzerProvider
extends AbstractIndexAnalyzerProvider<SnowballAnalyzer> {
    private static final ImmutableMap<String, CharArraySet> defaultLanguageStopwords = MapBuilder.newMapBuilder().put("English", StopAnalyzer.ENGLISH_STOP_WORDS_SET).put("Dutch", DutchAnalyzer.getDefaultStopSet()).put("German", GermanAnalyzer.getDefaultStopSet()).put("German2", GermanAnalyzer.getDefaultStopSet()).put("French", FrenchAnalyzer.getDefaultStopSet()).immutableMap();
    private final SnowballAnalyzer analyzer;

    @Inject
    public SnowballAnalyzerProvider(Index index, IndexSettingsService indexSettingsService, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name, settings);
        String language = settings.get("language", settings.get("name", "English"));
        CharArraySet defaultStopwords = defaultLanguageStopwords.containsKey((Object)language) ? (CharArraySet)defaultLanguageStopwords.get((Object)language) : CharArraySet.EMPTY_SET;
        CharArraySet stopWords = Analysis.parseStopWords(env, settings, defaultStopwords);
        this.analyzer = new SnowballAnalyzer(language, stopWords);
        this.analyzer.setVersion(this.version);
    }

    @Override
    public SnowballAnalyzer get() {
        return this.analyzer;
    }
}

