/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.FramedBox;
import org.scilab.forge.jlatexmath.RowAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;

public class FBoxAtom
extends Atom {
    public float INTERSPACE = 0.65f;
    protected final Atom base;
    protected Color bg = null;
    protected Color line = null;

    public FBoxAtom(Atom atom) {
        if (atom == null) {
            this.base = new RowAtom();
        } else {
            this.base = atom;
            this.type = atom.type;
        }
    }

    public FBoxAtom(Atom atom, Color color, Color color2) {
        this(atom);
        this.bg = color;
        this.line = color2;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        Box box = this.base.createBox(teXEnvironment);
        float f = teXEnvironment.getTeXFont().getDefaultRuleThickness(teXEnvironment.getStyle());
        float f2 = this.INTERSPACE * SpaceAtom.getFactor(0, teXEnvironment);
        if (this.bg == null) {
            return new FramedBox(box, f, f2);
        }
        teXEnvironment.isColored = true;
        return new FramedBox(box, f, f2, this.line, this.bg);
    }
}

