/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class NativeJavaTopPackage
extends NativeJavaPackage
implements Function,
IdFunctionCall {
    static final long serialVersionUID = -1455787259477709999L;
    private static final String[][] commonPackages = new String[][]{{"java", "lang", "reflect"}, {"java", "io"}, {"java", "math"}, {"java", "net"}, {"java", "util", "zip"}, {"java", "text", "resources"}, {"java", "applet"}, {"javax", "swing"}};
    private static final Object FTAG = "JavaTopPackage";
    private static final int Id_getClass = 1;

    NativeJavaTopPackage(ClassLoader classLoader) {
        super(true, "", classLoader);
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return this.construct(context, scriptable, objectArray);
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        Object object;
        ClassLoader classLoader = null;
        if (objectArray.length != 0) {
            object = objectArray[0];
            if (object instanceof Wrapper) {
                object = ((Wrapper)object).unwrap();
            }
            if (object instanceof ClassLoader) {
                classLoader = (ClassLoader)object;
            }
        }
        if (classLoader == null) {
            Context.reportRuntimeError0("msg.not.classloader");
            return null;
        }
        object = new NativeJavaPackage(true, "", classLoader);
        ScriptRuntime.setObjectProtoAndParent((ScriptableObject)object, scriptable);
        return object;
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        Object object;
        ClassLoader classLoader = context.getApplicationClassLoader();
        String[] stringArray = new NativeJavaTopPackage(classLoader);
        stringArray.setPrototype(NativeJavaTopPackage.getObjectPrototype(scriptable));
        stringArray.setParentScope(scriptable);
        for (int i = 0; i != commonPackages.length; ++i) {
            object = stringArray;
            for (int j = 0; j != commonPackages[i].length; ++j) {
                object = object.forcePackage(commonPackages[i][j], scriptable);
            }
        }
        IdFunctionObject idFunctionObject = new IdFunctionObject((IdFunctionCall)stringArray, FTAG, 1, "getClass", 1, scriptable);
        object = ScriptRuntime.getTopPackageNames();
        NativeJavaPackage[] nativeJavaPackageArray = new NativeJavaPackage[((String[])object).length];
        for (int i = 0; i < ((String[])object).length; ++i) {
            nativeJavaPackageArray[i] = (NativeJavaPackage)stringArray.get(object[i], (Scriptable)stringArray);
        }
        ScriptableObject scriptableObject = (ScriptableObject)scriptable;
        if (bl) {
            idFunctionObject.sealObject();
        }
        idFunctionObject.exportAsScopeProperty();
        scriptableObject.defineProperty("Packages", stringArray, 2);
        for (int i = 0; i < ((String[])object).length; ++i) {
            scriptableObject.defineProperty(object[i], nativeJavaPackageArray[i], 2);
        }
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (idFunctionObject.hasTag(FTAG) && idFunctionObject.methodId() == 1) {
            return this.js_getClass(context, scriptable, objectArray);
        }
        throw idFunctionObject.unknown();
    }

    private Scriptable js_getClass(Context context, Scriptable scriptable, Object[] objectArray) {
        if (objectArray.length > 0 && objectArray[0] instanceof Wrapper) {
            int n;
            String string;
            Object object;
            Scriptable scriptable2 = this;
            Class<?> clazz = ((Wrapper)objectArray[0]).unwrap().getClass();
            String string2 = clazz.getName();
            int n2 = 0;
            while ((object = scriptable2.get(string = (n = string2.indexOf(46, n2)) == -1 ? string2.substring(n2) : string2.substring(n2, n), scriptable2)) instanceof Scriptable) {
                scriptable2 = (Scriptable)object;
                if (n == -1) {
                    return scriptable2;
                }
                n2 = n + 1;
            }
        }
        throw Context.reportRuntimeError0("msg.not.java.obj");
    }
}

