/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.plugins.internal.tasks;

import com.google.common.base.Joiner;
import java.io.File;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GFileUtils;

public class PluginClasspathManifest
extends DefaultTask {
    private FileCollection pluginClasspath = this.getDefaultPluginClasspath();
    private File outputFile = this.getDefaultOutputFile();

    private FileCollection getDefaultPluginClasspath() {
        JavaPluginConvention javaConvention = (JavaPluginConvention)this.getProject().getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet mainSourceSet = (SourceSet)javaConvention.getSourceSets().findByName("main");
        return mainSourceSet != null ? mainSourceSet.getRuntimeClasspath() : null;
    }

    private File getDefaultOutputFile() {
        String pluginClasspath = String.format("%s/%s/plugin-classpath.txt", this.getProject().getBuildDir(), this.getName());
        return this.getProject().file((Object)pluginClasspath);
    }

    @InputFiles
    public FileCollection getPluginClasspath() {
        return this.pluginClasspath;
    }

    public void setPluginClasspath(FileCollection pluginClasspath) {
        this.pluginClasspath = pluginClasspath;
    }

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    @TaskAction
    public void generate() {
        List paths = CollectionUtils.collect((Iterable)this.getPluginClasspath(), (Transformer)new Transformer<String, File>(){

            public String transform(File file) {
                return file.getAbsolutePath().replaceAll("\\\\", "/");
            }
        });
        String joinedPaths = Joiner.on((String)"\n").join((Iterable)paths);
        GFileUtils.writeFile((String)joinedPaths, (File)this.getOutputFile());
    }
}

