/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class AddMethodFix
extends GroovyFix {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.codeInspection.bugs.GroovyRangeTypeCheckInspection");
    private final String myMethodName;
    private final GrTypeDefinition myClass;

    public AddMethodFix(String methodName, GrTypeDefinition aClass) {
        this.myMethodName = methodName;
        this.myClass = aClass;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        if (this.myClass.isInterface()) {
            GrMethod method = GroovyPsiElementFactory.getInstance(project).createMethodFromText("def " + this.myClass.getName() + " " + this.myMethodName + "();");
            this.myClass.add(method);
        } else {
            String templName = "Implemented Method Body.java";
            FileTemplate template = FileTemplateManager.getInstance((Project)project).getCodeTemplate(templName);
            Properties properties = new Properties();
            String returnType = AddMethodFix.generateTypeText(this.myClass);
            properties.setProperty("RETURN_TYPE", returnType);
            properties.setProperty("DEFAULT_RETURN_VALUE", PsiTypesUtil.getDefaultValueOfType((PsiType)JavaPsiFacade.getElementFactory((Project)project).createType((PsiClass)this.myClass)));
            properties.setProperty("CALL_SUPER", "");
            properties.setProperty("CLASS_NAME", this.myClass.getQualifiedName());
            properties.setProperty("SIMPLE_CLASS_NAME", this.myClass.getName());
            properties.setProperty("METHOD_NAME", this.myMethodName);
            try {
                String bodyText = StringUtil.replace((String)template.getText(properties), (String)";", (String)"");
                GrCodeBlock newBody = GroovyPsiElementFactory.getInstance(project).createMethodBodyFromText("\n" + bodyText + "\n");
                GrMethod method = GroovyPsiElementFactory.getInstance(project).createMethodFromText("", this.myMethodName, returnType, ArrayUtil.EMPTY_STRING_ARRAY, this.myClass);
                method.setBlock(newBody);
                this.myClass.add(method);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    public String getName() {
        String string = GroovyInspectionBundle.message("add.method", this.myMethodName, this.myClass.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/AddMethodFix", "getName"));
        }
        return string;
    }

    static String generateTypeText(GrTypeDefinition aClass) {
        StringBuilder returnType = new StringBuilder(aClass.getName());
        PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
        if (typeParameters.length > 0) {
            returnType.append('<');
            for (PsiTypeParameter typeParameter : typeParameters) {
                returnType.append(typeParameter.getName()).append(", ");
            }
            returnType.replace(returnType.length() - 2, returnType.length(), ">");
        }
        return returnType.toString();
    }
}

