/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.unwrap.GroovyUnwrapper;

public class GroovyCatchRemover
extends GroovyUnwrapper {
    public GroovyCatchRemover() {
        super(CodeInsightBundle.message((String)"remove.catch", (Object[])new Object[0]));
    }

    public boolean isApplicableTo(PsiElement e) {
        return e instanceof GrCatchClause && GroovyCatchRemover.tryHasSeveralCatches(e);
    }

    private static boolean tryHasSeveralCatches(PsiElement el) {
        return ((GrTryCatchStatement)el.getParent()).getCatchClauses().length > 1;
    }

    protected void doUnwrap(PsiElement element, GroovyUnwrapper.Context context) throws IncorrectOperationException {
        context.delete(element);
    }
}

