/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JUnitConfigurationType
implements ConfigurationType {
    private final ConfigurationFactory myFactory = new ConfigurationFactoryEx(this){

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new JUnitConfiguration("", project, (ConfigurationFactory)this);
        }

        public void onNewConfigurationCreated(@NotNull RunConfiguration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/junit/JUnitConfigurationType$1", "onNewConfigurationCreated"));
            }
            ((ModuleBasedConfiguration)configuration).onNewConfigurationCreated();
        }
    };

    public String getDisplayName() {
        return ExecutionBundle.message((String)"junit.configuration.display.name", (Object[])new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return ExecutionBundle.message((String)"junit.configuration.description", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return AllIcons.RunConfigurations.Junit;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    @NotNull
    public String getId() {
        if ("JUnit" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnitConfigurationType", "getId"));
        }
        return "JUnit";
    }

    @NotNull
    public static JUnitConfigurationType getInstance() {
        JUnitConfigurationType jUnitConfigurationType = (JUnitConfigurationType)ConfigurationTypeUtil.findConfigurationType(JUnitConfigurationType.class);
        if (jUnitConfigurationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnitConfigurationType", "getInstance"));
        }
        return jUnitConfigurationType;
    }
}

