/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectCollectedException;

public class EvaluateExceptionUtil {
    public static final EvaluateException INCONSISTEND_DEBUG_INFO = EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.inconsistent.debug.info", new Object[0]));
    public static final EvaluateException BOOLEAN_EXPECTED = EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.boolean.value.expected.in.condition", new Object[0]));
    public static final EvaluateException PROCESS_EXITED = EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.process.exited", new Object[0]));
    public static final EvaluateException NULL_STACK_FRAME = EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.stack.frame.unavailable", new Object[0]));
    public static final EvaluateException NESTED_EVALUATION_ERROR = EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.nested.evaluation", new Object[0]));
    public static final EvaluateException INVALID_DEBUG_INFO = EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.sources.out.of.sync", new Object[0]));
    public static final EvaluateException CANNOT_FIND_SOURCE_CLASS = EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.cannot.find.stackframe.source", new Object[0]));
    public static final EvaluateException OBJECT_WAS_COLLECTED = EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.object.collected", new Object[0]));
    public static final EvaluateException ARRAY_WAS_COLLECTED = EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.array.collected", new Object[0]));
    public static final EvaluateException THREAD_WAS_RESUMED = EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.thread.resumed", new Object[0]));
    public static final EvaluateException DEBUG_INFO_UNAVAILABLE = EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.debug.info.unavailable", new Object[0]));

    private EvaluateExceptionUtil() {
    }

    public static EvaluateException createEvaluateException(Throwable th) {
        return EvaluateExceptionUtil.createEvaluateException(null, th);
    }

    public static EvaluateException createEvaluateException(String msg, Throwable th) {
        String message = msg != null ? msg + ": " + EvaluateExceptionUtil.reason(th) : EvaluateExceptionUtil.reason(th);
        return new EvaluateException(message, th instanceof EvaluateException ? th.getCause() : th);
    }

    public static EvaluateException createEvaluateException(String reason) {
        return new EvaluateException(reason, null);
    }

    private static String reason(Throwable th) {
        if (th instanceof InvalidTypeException) {
            String originalReason = th.getMessage();
            return DebuggerBundle.message("evaluation.error.type.mismatch", new Object[0]) + (originalReason != null ? " " + originalReason : "");
        }
        if (th instanceof AbsentInformationException) {
            return DebuggerBundle.message("evaluation.error.debug.info.unavailable", new Object[0]);
        }
        if (th instanceof ClassNotLoadedException) {
            return DebuggerBundle.message("evaluation.error.class.not.loaded", ((ClassNotLoadedException)th).className());
        }
        if (th instanceof ClassNotPreparedException) {
            return th.getMessage();
        }
        if (th instanceof IncompatibleThreadStateException) {
            return DebuggerBundle.message("evaluation.error.thread.not.at.breakpoint", new Object[0]);
        }
        if (th instanceof InconsistentDebugInfoException) {
            return DebuggerBundle.message("evaluation.error.inconsistent.debug.info", new Object[0]);
        }
        if (th instanceof ObjectCollectedException) {
            return DebuggerBundle.message("evaluation.error.object.collected", new Object[0]);
        }
        if (th instanceof InvocationException) {
            InvocationException invocationException = (InvocationException)th;
            return DebuggerBundle.message("evaluation.error.method.exception", invocationException.exception().referenceType().name());
        }
        if (th instanceof EvaluateException) {
            return th.getMessage();
        }
        StringBuilder res = new StringBuilder(th.getClass().getName());
        String message = th.getMessage();
        if (!StringUtil.isEmpty((String)message)) {
            res.append(" : ").append(message);
        }
        return res.toString();
    }
}

