/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaElementPattern<T extends PsiElement, Self extends PsiJavaElementPattern<T, Self>>
extends PsiElementPattern<T, Self> {
    @NonNls
    private static final String VALUE = "value";

    public PsiJavaElementPattern(Class<T> aClass) {
        super(aClass);
    }

    public PsiJavaElementPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/PsiJavaElementPattern", "<init>"));
        }
        super(condition);
    }

    public Self annotationParam(@NonNls String annotationQualifiedName, @NonNls String parameterName) {
        return this.annotationParam((ElementPattern<String>)StandardPatterns.string().equalTo(annotationQualifiedName), parameterName);
    }

    public Self annotationParam(@NonNls String annotationQualifiedName) {
        return this.annotationParam(annotationQualifiedName, VALUE);
    }

    public Self annotationParam(ElementPattern<String> annotationQualifiedName, @NonNls String parameterName) {
        return (Self)((PsiJavaElementPattern)this.withParent(PsiJavaPatterns.psiNameValuePair().withName(parameterName).withParent(PlatformPatterns.psiElement(PsiAnnotationParameterList.class).withParent(PsiJavaPatterns.psiAnnotation().qName(annotationQualifiedName)))));
    }

    public Self annotationParam(@NotNull ElementPattern<PsiAnnotation> annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/patterns/PsiJavaElementPattern", "annotationParam"));
        }
        return (Self)((PsiJavaElementPattern)this.withParent(PsiJavaPatterns.psiNameValuePair().withParent(PlatformPatterns.psiElement(PsiAnnotationParameterList.class).withParent(annotation))));
    }

    public Self annotationParam(String parameterName, @NotNull ElementPattern<PsiAnnotation> annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/patterns/PsiJavaElementPattern", "annotationParam"));
        }
        return (Self)((PsiJavaElementPattern)this.withParent(PsiJavaPatterns.psiNameValuePair().withName(parameterName).withParent(PlatformPatterns.psiElement(PsiAnnotationParameterList.class).withParent(annotation))));
    }

    public Self insideAnnotationParam(ElementPattern<String> annotationQualifiedName, @NonNls String parameterName) {
        return (Self)((PsiJavaElementPattern)this.withAncestor(3, PsiJavaPatterns.psiNameValuePair().withName(parameterName).withParent(PlatformPatterns.psiElement(PsiAnnotationParameterList.class).withParent(PsiJavaPatterns.psiAnnotation().qName(annotationQualifiedName)))));
    }

    public Self insideAnnotationParam(ElementPattern<String> annotationQualifiedName) {
        return this.insideAnnotationParam(annotationQualifiedName, VALUE);
    }

    public Self insideAnnotationParam(@NotNull String annotationQualifiedName) {
        if (annotationQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationQualifiedName", "com/intellij/patterns/PsiJavaElementPattern", "insideAnnotationParam"));
        }
        return this.insideAnnotationParam((ElementPattern<String>)StandardPatterns.string().equalTo(annotationQualifiedName));
    }

    public Self nameIdentifierOf(Class<? extends PsiMember> aClass) {
        return this.nameIdentifierOf(StandardPatterns.instanceOf(aClass));
    }

    public Self nameIdentifierOf(final ElementPattern<? extends PsiMember> pattern) {
        return (Self)((PsiJavaElementPattern)this.with(new PatternCondition<T>("nameIdentifierOf"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiJavaElementPattern$1", "accepts"));
                }
                if (!(t instanceof PsiIdentifier)) {
                    return false;
                }
                PsiElement parent = t.getParent();
                if (parent instanceof PsiClass && t != ((PsiClass)parent).getNameIdentifier()) {
                    return false;
                }
                if (parent instanceof PsiMethod && t != ((PsiMethod)parent).getNameIdentifier()) {
                    return false;
                }
                if (parent instanceof PsiVariable && t != ((PsiVariable)parent).getNameIdentifier()) {
                    return false;
                }
                return pattern.accepts(parent, context);
            }
        }));
    }

    public Self methodCallParameter(final int index, final ElementPattern<? extends PsiMethod> methodPattern) {
        final PsiNamePatternCondition nameCondition = (PsiNamePatternCondition)ContainerUtil.findInstance(methodPattern.getCondition().getConditions(), PsiNamePatternCondition.class);
        return (Self)((PsiJavaElementPattern)this.with(new PatternCondition<T>("methodCallParameter"){

            @Override
            public boolean accepts(@NotNull T literal, ProcessingContext context) {
                if (literal == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/patterns/PsiJavaElementPattern$2", "accepts"));
                }
                PsiElement parent = literal.getParent();
                if (parent instanceof PsiExpressionList) {
                    PsiExpressionList psiExpressionList = (PsiExpressionList)parent;
                    PsiExpression[] psiExpressions = psiExpressionList.getExpressions();
                    if (psiExpressions.length <= index || psiExpressions[index] != literal) {
                        return false;
                    }
                    return PsiJavaElementPattern.checkCall(context, psiExpressionList, methodPattern, nameCondition);
                }
                return false;
            }
        }));
    }

    public Self methodCallParameter(final @NotNull ElementPattern<? extends PsiMethod> methodPattern) {
        if (methodPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodPattern", "com/intellij/patterns/PsiJavaElementPattern", "methodCallParameter"));
        }
        final PsiNamePatternCondition nameCondition = (PsiNamePatternCondition)ContainerUtil.findInstance(methodPattern.getCondition().getConditions(), PsiNamePatternCondition.class);
        return (Self)((PsiJavaElementPattern)this.with(new PatternCondition<T>("methodCallParameter"){

            @Override
            public boolean accepts(@NotNull T literal, ProcessingContext context) {
                if (literal == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/patterns/PsiJavaElementPattern$3", "accepts"));
                }
                PsiElement parent = literal.getParent();
                return parent instanceof PsiExpressionList && PsiJavaElementPattern.checkCall(context, (PsiExpressionList)parent, methodPattern, nameCondition);
            }
        }));
    }

    private static boolean checkCall(ProcessingContext context, PsiExpressionList psiExpressionList, ElementPattern<? extends PsiMethod> methodPattern, @Nullable PsiNamePatternCondition nameCondition) {
        PsiElement element = psiExpressionList.getParent();
        if (element instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)element).getMethodExpression();
            if (nameCondition != null && !nameCondition.getNamePattern().accepts(methodExpression.getReferenceName())) {
                return false;
            }
            for (JavaResolveResult result : methodExpression.multiResolve(false)) {
                if (!methodPattern.accepts(result.getElement(), context)) continue;
                return true;
            }
        }
        return false;
    }

    public Self constructorParameter(final int index, final String ... fqns) {
        return (Self)((PsiJavaElementPattern)this.with(new PatternCondition<T>("constructorParameter"){

            @Override
            public boolean accepts(@NotNull T literal, ProcessingContext context) {
                if (literal == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/patterns/PsiJavaElementPattern$4", "accepts"));
                }
                PsiElement parent = literal.getParent();
                if (parent instanceof PsiExpressionList) {
                    PsiJavaCodeReferenceElement reference;
                    PsiExpressionList psiExpressionList = (PsiExpressionList)parent;
                    PsiExpression[] psiExpressions = psiExpressionList.getExpressions();
                    if (psiExpressions.length <= index || psiExpressions[index] != literal) {
                        return false;
                    }
                    PsiElement element = psiExpressionList.getParent();
                    if (element instanceof PsiNewExpression && (reference = ((PsiNewExpression)element).getClassOrAnonymousClassReference()) != null) {
                        String qualifiedName = reference.getQualifiedName();
                        for (String fqn : fqns) {
                            if (!fqn.equals(qualifiedName)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        }));
    }

    public static class Capture<T extends PsiElement>
    extends PsiJavaElementPattern<T, Capture<T>> {
        public Capture(Class<T> aClass) {
            super(aClass);
        }

        public Capture(@NotNull InitialPatternCondition<T> condition) {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/PsiJavaElementPattern$Capture", "<init>"));
            }
            super(condition);
        }
    }
}

