/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.containers.Stack;

public abstract class JavaRecursiveElementVisitor
extends JavaElementVisitor {
    private final Stack<PsiReferenceExpression> myRefExprsInVisit = new Stack();
    private final Stack<PsiBinaryExpression> myBinaryExpressions = new Stack();

    @Override
    public void visitElement(PsiElement element) {
        if (!this.myRefExprsInVisit.isEmpty() && this.myRefExprsInVisit.peek() == element) {
            this.myRefExprsInVisit.pop();
            this.myRefExprsInVisit.push(null);
        } else if (element instanceof PsiBinaryExpression) {
            if (!this.myBinaryExpressions.isEmpty() && this.myBinaryExpressions.peek() == element) {
                return;
            }
            PsiElement child = element.getFirstChild();
            while (child != null) {
                if (child instanceof PsiBinaryExpression) {
                    this.myBinaryExpressions.push((Object)((PsiBinaryExpression)child));
                }
                child.accept(this);
                if ((child = child.getNextSibling()) != null || (child = this.myBinaryExpressions.isEmpty() ? null : (PsiBinaryExpression)this.myBinaryExpressions.pop()) == null) continue;
                child = child.getFirstChild();
            }
        } else {
            element.acceptChildren(this);
        }
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression) {
        this.myRefExprsInVisit.push((Object)expression);
        try {
            this.visitExpression(expression);
            this.visitReferenceElement(expression);
        }
        finally {
            this.myRefExprsInVisit.pop();
        }
    }
}

