/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.group;

import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import org.jetbrains.annotations.NotNull;

public class ArrangementGroupingRule {
    @NotNull
    private final ArrangementSettingsToken myGroupingType;
    @NotNull
    private final ArrangementSettingsToken myOrderType;

    public ArrangementGroupingRule(@NotNull ArrangementSettingsToken groupingType) {
        if (groupingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupingType", "com/intellij/psi/codeStyle/arrangement/group/ArrangementGroupingRule", "<init>"));
        }
        this(groupingType, StdArrangementTokens.Order.KEEP);
    }

    public ArrangementGroupingRule(@NotNull ArrangementSettingsToken groupingType, @NotNull ArrangementSettingsToken orderType) {
        if (groupingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupingType", "com/intellij/psi/codeStyle/arrangement/group/ArrangementGroupingRule", "<init>"));
        }
        if (orderType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderType", "com/intellij/psi/codeStyle/arrangement/group/ArrangementGroupingRule", "<init>"));
        }
        this.myGroupingType = groupingType;
        this.myOrderType = orderType;
    }

    @NotNull
    public ArrangementSettingsToken getGroupingType() {
        ArrangementSettingsToken arrangementSettingsToken = this.myGroupingType;
        if (arrangementSettingsToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/group/ArrangementGroupingRule", "getGroupingType"));
        }
        return arrangementSettingsToken;
    }

    @NotNull
    public ArrangementSettingsToken getOrderType() {
        ArrangementSettingsToken arrangementSettingsToken = this.myOrderType;
        if (arrangementSettingsToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/group/ArrangementGroupingRule", "getOrderType"));
        }
        return arrangementSettingsToken;
    }

    public ArrangementGroupingRule clone() {
        return new ArrangementGroupingRule(this.myGroupingType, this.myOrderType);
    }

    public int hashCode() {
        int result = this.myGroupingType.hashCode();
        result = 31 * result + this.myOrderType.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrangementGroupingRule rule = (ArrangementGroupingRule)o;
        if (this.myOrderType != rule.myOrderType) {
            return false;
        }
        return this.myGroupingType.equals(rule.myGroupingType);
    }

    public String toString() {
        return String.format("(%s, %s)", this.myGroupingType, this.myOrderType);
    }
}

