/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.ex;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.JpsModel;

public abstract class JpsElementBase<Self extends JpsElementBase<Self>>
implements JpsElement,
JpsElement.BulkModificationSupport<Self> {
    protected JpsElementBase myParent;

    protected JpsElementBase() {
    }

    public void setParent(@Nullable JpsElementBase<?> parent) {
        if (this.myParent != null && parent != null) {
            throw new AssertionError((Object)("Parent for " + this + " is already set: " + this.myParent));
        }
        this.myParent = parent;
    }

    protected void fireElementChanged() {
        JpsEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.fireElementChanged(this);
        }
    }

    protected static void setParent(@NotNull JpsElement element, @Nullable JpsElementBase<?> parent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jps/model/ex/JpsElementBase", "setParent"));
        }
        ((JpsElementBase)element).setParent(parent);
    }

    @Nullable
    protected JpsEventDispatcher getEventDispatcher() {
        if (this.myParent != null) {
            return this.myParent.getEventDispatcher();
        }
        return null;
    }

    @Nullable
    protected JpsModel getModel() {
        if (this.myParent != null) {
            return this.myParent.getModel();
        }
        return null;
    }

    @Override
    @NotNull
    public JpsElement.BulkModificationSupport<?> getBulkModificationSupport() {
        JpsElementBase jpsElementBase = this;
        if (jpsElementBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/ex/JpsElementBase", "getBulkModificationSupport"));
        }
        return jpsElementBase;
    }

    @Override
    @NotNull
    public abstract Self createCopy();

    @Override
    public abstract void applyChanges(@NotNull Self var1);

    public JpsElementBase getParent() {
        return this.myParent;
    }
}

