/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsNotifier;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubNotifications {
    private static final Logger LOG = GithubUtil.LOG;

    private static boolean isOperationCanceled(@NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/github/util/GithubNotifications", "isOperationCanceled"));
        }
        return e instanceof GithubOperationCanceledException || e instanceof ProcessCanceledException;
    }

    public static void showInfo(@NotNull Project project, @NotNull String title, @NotNull String message) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfo"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfo"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfo"));
        }
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyImportantInfo(title, message);
    }

    public static void showWarning(@NotNull Project project, @NotNull String title, @NotNull String message) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarning"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarning"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarning"));
        }
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyImportantWarning(title, message);
    }

    public static void showWarning(@NotNull Project project, @NotNull String title, @NotNull Exception e) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarning"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarning"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarning"));
        }
        LOG.info(title + "; ", (Throwable)e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        VcsNotifier.getInstance((Project)project).notifyImportantWarning(title, GithubUtil.getErrorTextFromException(e));
    }

    public static void showError(@NotNull Project project, @NotNull String title, @NotNull String message) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        LOG.info(title + "; " + message);
        VcsNotifier.getInstance((Project)project).notifyError(title, message);
    }

    public static void showError(@NotNull Project project, @NotNull String title, @NotNull String message, @NotNull String logDetails) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        if (logDetails == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDetails", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        LOG.warn(title + "; " + message + "; " + logDetails);
        VcsNotifier.getInstance((Project)project).notifyError(title, message);
    }

    public static void showError(@NotNull Project project, @NotNull String title, @NotNull Exception e) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/github/util/GithubNotifications", "showError"));
        }
        LOG.warn(title + "; ", (Throwable)e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        VcsNotifier.getInstance((Project)project).notifyError(title, GithubUtil.getErrorTextFromException(e));
    }

    public static void showInfoURL(@NotNull Project project, @NotNull String title, @NotNull String message, @NotNull String url) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfoURL"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfoURL"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfoURL"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfoURL"));
        }
        LOG.info(title + "; " + message + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyImportantInfo(title, "<a href='" + url + "'>" + message + "</a>", NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showWarningURL(@NotNull Project project, @NotNull String title, @NotNull String prefix, @NotNull String highlight, @NotNull String postfix, @NotNull String url) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningURL"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningURL"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningURL"));
        }
        if (highlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlight", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningURL"));
        }
        if (postfix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postfix", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningURL"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningURL"));
        }
        LOG.info(title + "; " + prefix + highlight + postfix + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyImportantWarning(title, prefix + "<a href='" + url + "'>" + highlight + "</a>" + postfix, NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showErrorURL(@NotNull Project project, @NotNull String title, @NotNull String prefix, @NotNull String highlight, @NotNull String postfix, @NotNull String url) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorURL"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorURL"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorURL"));
        }
        if (highlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlight", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorURL"));
        }
        if (postfix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postfix", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorURL"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorURL"));
        }
        LOG.info(title + "; " + prefix + highlight + postfix + "; " + url);
        VcsNotifier.getInstance((Project)project).notifyError(title, prefix + "<a href='" + url + "'>" + highlight + "</a>" + postfix, NotificationListener.URL_OPENING_LISTENER);
    }

    public static void showInfoDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfoDialog"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfoDialog"));
        }
        LOG.info(title + "; " + message);
        Messages.showInfoMessage((Project)project, (String)message, (String)title);
    }

    public static void showInfoDialog(@NotNull Component component, @NotNull String title, @NotNull String message) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfoDialog"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfoDialog"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/github/util/GithubNotifications", "showInfoDialog"));
        }
        LOG.info(title + "; " + message);
        Messages.showInfoMessage((Component)component, (String)message, (String)title);
    }

    public static void showWarningDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningDialog"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningDialog"));
        }
        LOG.info(title + "; " + message);
        Messages.showWarningDialog((Project)project, (String)message, (String)title);
    }

    public static void showWarningDialog(@NotNull Component component, @NotNull String title, @NotNull String message) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningDialog"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningDialog"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/github/util/GithubNotifications", "showWarningDialog"));
        }
        LOG.info(title + "; " + message);
        Messages.showWarningDialog((Component)component, (String)message, (String)title);
    }

    public static void showErrorDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        LOG.info(title + "; " + message);
        Messages.showErrorDialog((Project)project, (String)message, (String)title);
    }

    public static void showErrorDialog(@Nullable Project project, @NotNull String title, @NotNull Exception e) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        LOG.warn(title, (Throwable)e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        Messages.showErrorDialog((Project)project, (String)GithubUtil.getErrorTextFromException(e), (String)title);
    }

    public static void showErrorDialog(@NotNull Component component, @NotNull String title, @NotNull Exception e) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        LOG.info(title, (Throwable)e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        Messages.showErrorDialog((Component)component, (String)GithubUtil.getErrorTextFromException(e), (String)title);
    }

    public static void showErrorDialog(@NotNull Component component, @NotNull String title, @NotNull String prefix, @NotNull Exception e) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/github/util/GithubNotifications", "showErrorDialog"));
        }
        LOG.info(title, (Throwable)e);
        if (GithubNotifications.isOperationCanceled(e)) {
            return;
        }
        Messages.showErrorDialog((Component)component, (String)(prefix + GithubUtil.getErrorTextFromException(e)), (String)title);
    }

    @Messages.YesNoResult
    public static boolean showYesNoDialog(@Nullable Project project, @NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showYesNoDialog"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/github/util/GithubNotifications", "showYesNoDialog"));
        }
        return 0 == Messages.showYesNoDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon());
    }

    @Messages.YesNoResult
    public static boolean showYesNoDialog(@Nullable Project project, @NotNull String title, @NotNull String message, @NotNull DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/util/GithubNotifications", "showYesNoDialog"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/github/util/GithubNotifications", "showYesNoDialog"));
        }
        if (doNotAskOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doNotAskOption", "org/jetbrains/plugins/github/util/GithubNotifications", "showYesNoDialog"));
        }
        return 0 == Messages.showYesNoDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption);
    }
}

