/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.openapi.util.text.StringUtil;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class WarDirectory
implements Serializable {
    public static final WarDirectory WAR_ROOT = new WarDirectory("/");
    public static final WarDirectory META_INF = new WarDirectory("/META-INF");
    public static final WarDirectory WEB_INF = new WarDirectory("/WEB-INF");
    public static final WarDirectory WEB_INF_LIB = new WarDirectory("/WEB-INF/lib");
    public static final WarDirectory WEB_INF_CLASSES = new WarDirectory("/WEB-INF/classes");
    private static final WarDirectory[] WAR_DIRECTORIES = new WarDirectory[]{WAR_ROOT, META_INF, WEB_INF, WEB_INF_LIB, WEB_INF_CLASSES};
    @NotNull
    private final String myRelativePath;

    WarDirectory(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/plugins/gradle/model/data/WarDirectory", "<init>"));
        }
        this.myRelativePath = WarDirectory.getAdjustedPath(relativePath);
    }

    @NotNull
    public String getRelativePath() {
        String string = this.myRelativePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/WarDirectory", "getRelativePath"));
        }
        return string;
    }

    public boolean isCustomDirectory() {
        for (WarDirectory warDirectory : WAR_DIRECTORIES) {
            if (!this.myRelativePath.equals(warDirectory.getRelativePath())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static WarDirectory fromPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/gradle/model/data/WarDirectory", "fromPath"));
        }
        if (StringUtil.isEmpty((String)path)) {
            WarDirectory warDirectory = WAR_ROOT;
            if (warDirectory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/WarDirectory", "fromPath"));
            }
            return warDirectory;
        }
        String adjustedPath = WarDirectory.getAdjustedPath(path);
        for (WarDirectory warDirectory : WAR_DIRECTORIES) {
            if (!warDirectory.myRelativePath.equals(adjustedPath)) continue;
            WarDirectory warDirectory2 = warDirectory;
            if (warDirectory2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/WarDirectory", "fromPath"));
            }
            return warDirectory2;
        }
        WarDirectory warDirectory = new WarDirectory(adjustedPath);
        if (warDirectory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/WarDirectory", "fromPath"));
        }
        return warDirectory;
    }

    private static String getAdjustedPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/gradle/model/data/WarDirectory", "getAdjustedPath"));
        }
        return path.isEmpty() || path.charAt(0) != '/' ? '/' + path : path;
    }

    public String toString() {
        return this.myRelativePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WarDirectory directory = (WarDirectory)o;
        return this.myRelativePath.equals(directory.myRelativePath);
    }

    public int hashCode() {
        return this.myRelativePath.hashCode();
    }
}

