/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.collection.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.internal.Cast;
import org.gradle.model.ModelMap;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.model.collection.internal.ChildNodeInitializerStrategyAccessor;
import org.gradle.model.internal.core.ChildNodeInitializerStrategy;
import org.gradle.model.internal.core.DefaultModelViewState;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelMapGroovyDecorator;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeBackedModelMap;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.ModelTypes;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelMapModelProjection<I>
implements ModelProjection {
    private static final Set<Class<?>> SUPPORTED_CONTAINER_TYPES = ImmutableSet.of(ModelMap.class, CollectionBuilder.class);
    protected final Class<I> baseItemType;
    protected final ModelType<I> baseItemModelType;
    private final boolean eager;
    private final ChildNodeInitializerStrategyAccessor<? super I> creatorStrategyAccessor;
    private final boolean managed;

    public static <T> ModelProjection unmanaged(ModelType<T> itemType, ChildNodeInitializerStrategyAccessor<? super T> creatorStrategyAccessor) {
        return new ModelMapModelProjection<T>(itemType, false, false, creatorStrategyAccessor);
    }

    public static <T> ModelProjection unmanaged(Class<T> itemType, ChildNodeInitializerStrategyAccessor<? super T> creatorStrategyAccessor) {
        return ModelMapModelProjection.unmanaged(ModelType.of(itemType), creatorStrategyAccessor);
    }

    public static <T> ModelProjection managed(ModelType<T> itemType, ChildNodeInitializerStrategyAccessor<? super T> creatorStrategyAccessor) {
        return new ModelMapModelProjection<T>(itemType, false, true, creatorStrategyAccessor);
    }

    protected ModelMapModelProjection(ModelType<I> baseItemModelType, boolean eager, boolean managed, ChildNodeInitializerStrategyAccessor<? super I> creatorStrategyAccessor) {
        this.baseItemModelType = baseItemModelType;
        this.eager = eager;
        this.managed = managed;
        this.baseItemType = baseItemModelType.getConcreteClass();
        this.creatorStrategyAccessor = creatorStrategyAccessor;
    }

    protected Collection<? extends Class<?>> getCreatableTypes(MutableModelNode node) {
        return Collections.singleton(this.baseItemType);
    }

    private String getContainerTypeDescription(Class<?> containerType, Collection<? extends Class<?>> creatableTypes) {
        StringBuilder sb = new StringBuilder(containerType.getName());
        if (creatableTypes.size() == 1) {
            String onlyType = ((Class)Iterables.getFirst(creatableTypes, null)).getName();
            sb.append("<").append(onlyType).append(">");
        } else {
            sb.append("<T>; where T is one of [");
            Joiner.on((String)", ").appendTo(sb, (Iterable)CollectionUtils.sort((Iterable)Iterables.transform(creatableTypes, (Function)new Function<Class<?>, String>(){

                public String apply(Class<?> input) {
                    return input.getName();
                }
            })));
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public Iterable<String> getReadableTypeDescriptions(MutableModelNode node) {
        return this.getWritableTypeDescriptions(node);
    }

    protected Class<? extends I> itemType(ModelType<?> targetType) {
        Class<ModelMap> targetClass = targetType.getRawClass();
        if (SUPPORTED_CONTAINER_TYPES.contains(targetClass)) {
            Class<I> targetItemClass = targetType.getTypeVariables().get(0).getRawClass();
            if (targetItemClass.isAssignableFrom(this.baseItemType)) {
                return this.baseItemType;
            }
            if (this.baseItemType.isAssignableFrom(targetItemClass)) {
                return targetItemClass.asSubclass(this.baseItemType);
            }
            return null;
        }
        if (targetClass.isAssignableFrom(ModelMap.class)) {
            return this.baseItemType;
        }
        return null;
    }

    @Override
    public <T> boolean canBeViewedAsMutable(ModelType<T> targetType) {
        return this.itemType(targetType) != null;
    }

    @Override
    public <T> boolean canBeViewedAsImmutable(ModelType<T> type) {
        return this.canBeViewedAsMutable(type);
    }

    @Override
    public <T> ModelView<? extends T> asImmutable(ModelType<T> type, MutableModelNode modelNode, @Nullable ModelRuleDescriptor ruleDescriptor) {
        return this.doAs(type, modelNode, ruleDescriptor, false);
    }

    @Override
    public <T> ModelView<? extends T> asMutable(ModelType<T> targetType, MutableModelNode node, ModelRuleDescriptor ruleDescriptor, List<ModelView<?>> inputs) {
        return this.doAs(targetType, node, ruleDescriptor, true);
    }

    @Nullable
    private <T> ModelView<? extends T> doAs(ModelType<T> targetType, MutableModelNode node, ModelRuleDescriptor ruleDescriptor, boolean mutable) {
        Class<I> itemType = this.itemType(targetType);
        if (itemType != null) {
            return (ModelView)Cast.uncheckedCast(this.toView(targetType, ruleDescriptor, node, itemType, mutable, !this.managed || !mutable));
        }
        return null;
    }

    private <T, S extends I> ModelView<ModelMap<S>> toView(ModelType<T> targetType, ModelRuleDescriptor sourceDescriptor, MutableModelNode node, Class<S> itemClass, boolean mutable, boolean canReadChildren) {
        ChildNodeInitializerStrategy<? super I> creatorStrategy = this.creatorStrategyAccessor.getStrategy(node);
        DefaultModelViewState state = new DefaultModelViewState(targetType, sourceDescriptor, mutable, canReadChildren);
        ModelType<S> itemType = ModelType.of(itemClass);
        NodeBackedModelMap<I> builder = new NodeBackedModelMap<I>(this.baseItemModelType, sourceDescriptor, node, this.eager, state, creatorStrategy);
        return InstanceModelView.of(node.getPath(), ModelTypes.modelMap(itemType), ModelMapGroovyDecorator.wrap(builder.withType(itemClass)), state.closer());
    }

    @Override
    public Iterable<String> getWritableTypeDescriptions(MutableModelNode node) {
        final Collection<Class<?>> creatableTypes = this.getCreatableTypes(node);
        return Iterables.transform(SUPPORTED_CONTAINER_TYPES, (Function)new Function<Class<?>, String>(){

            public String apply(Class<?> containerType) {
                return ModelMapModelProjection.this.getContainerTypeDescription(containerType, creatableTypes);
            }
        });
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelMapModelProjection that = (ModelMapModelProjection)o;
        return this.baseItemType.equals(that.baseItemType) && this.baseItemModelType.equals(that.baseItemModelType);
    }

    public int hashCode() {
        int result = this.baseItemType.hashCode();
        result = 31 * result + this.baseItemModelType.hashCode();
        return result;
    }

    @Override
    public Optional<String> getValueDescription(MutableModelNode modelNodeInternal) {
        return Optional.absent();
    }
}

