/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.CreatorRuleBinder;
import org.gradle.model.internal.registry.ModelActionBinder;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.RuleBinder;
import org.gradle.model.internal.type.ModelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ModelNodeInternal
implements MutableModelNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelNodeInternal.class);
    private CreatorRuleBinder creatorBinder;
    private final Set<ModelNodeInternal> dependencies = Sets.newHashSet();
    private final Set<ModelNodeInternal> dependents = Sets.newHashSet();
    private ModelNode.State state = ModelNode.State.Known;
    private boolean hidden;
    private final List<ModelRuleDescriptor> executedRules = Lists.newArrayList();
    private final List<ModelActionBinder> initializerRuleBinders = Lists.newArrayList();

    public ModelNodeInternal(CreatorRuleBinder creatorBinder) {
        this.creatorBinder = creatorBinder;
    }

    public CreatorRuleBinder getCreatorBinder() {
        return this.creatorBinder;
    }

    public void replaceCreatorRuleBinder(CreatorRuleBinder newCreatorBinder) {
        if (this.isAtLeast(ModelNode.State.Created)) {
            throw new IllegalStateException("Cannot replace creator rule binder when node is already created (node: " + this + ", state: " + (Object)((Object)this.getState()) + ")");
        }
        ModelCreator newCreator = newCreatorBinder.getCreator();
        ModelCreator oldCreator = this.creatorBinder.getCreator();
        if (!oldCreator.getPromise().equals(newCreator.getPromise())) {
            throw new IllegalStateException("can not replace node " + this.getPath() + " with different promise (old: " + oldCreator.getPromise() + ", new: " + newCreator.getPromise() + ")");
        }
        if (!newCreator.getInputs().equals(oldCreator.getInputs())) {
            Joiner joiner = Joiner.on((String)", ");
            throw new IllegalStateException("can not replace node " + this.getPath() + " with creator with different input bindings (old: [" + joiner.join(oldCreator.getInputs()) + "], new: [" + joiner.join(newCreator.getInputs()) + "])");
        }
        this.creatorBinder = newCreatorBinder;
    }

    public List<ModelActionBinder> getInitializerRuleBinders() {
        return this.initializerRuleBinders;
    }

    public void addInitializerRuleBinder(ModelActionBinder binder) {
        this.initializerRuleBinders.add(binder);
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isEphemeral() {
        return this.creatorBinder.getCreator().isEphemeral();
    }

    public void notifyFired(RuleBinder binder) {
        assert (binder.isBound()) : "RuleBinder must be in a bound state";
        for (ModelBinding inputBinding : binder.getInputBindings()) {
            ModelNodeInternal node = inputBinding.getNode();
            this.dependencies.add(node);
            node.dependents.add(this);
        }
        this.executedRules.add(binder.getDescriptor());
    }

    public Iterable<? extends ModelNode> getDependencies() {
        return this.dependencies;
    }

    public Iterable<? extends ModelNode> getDependents() {
        return this.dependents;
    }

    @Override
    public ModelPath getPath() {
        return this.creatorBinder.getCreator().getPath();
    }

    @Override
    public ModelRuleDescriptor getDescriptor() {
        return this.creatorBinder.getDescriptor();
    }

    @Override
    public ModelNode.State getState() {
        return this.state;
    }

    public void setState(ModelNode.State state) {
        this.state = state;
    }

    @Override
    public boolean isMutable() {
        return this.state.mutable;
    }

    @Override
    @Nullable
    public abstract ModelNodeInternal getLink(String var1);

    public ModelPromise getPromise() {
        if (!this.state.isAtLeast(ModelNode.State.ProjectionsDefined)) {
            throw new IllegalStateException(String.format("Cannot get promise for %s in state %s when projections are not yet defined", new Object[]{this.getPath(), this.state}));
        }
        return this.creatorBinder.getCreator().getPromise();
    }

    public ModelAdapter getAdapter() {
        if (!this.state.isAtLeast(ModelNode.State.Created)) {
            throw new IllegalStateException(String.format("Cannot get adapter for %s in state %s when node is not created", new Object[]{this.getPath(), this.state}));
        }
        return this.creatorBinder.getCreator().getAdapter();
    }

    public String toString() {
        return this.getPath().toString();
    }

    public abstract Iterable<? extends ModelNodeInternal> getLinks();

    @Override
    public boolean isAtLeast(ModelNode.State state) {
        return this.getState().compareTo(state) >= 0;
    }

    public void reset() {
        if (this.isAtLeast(ModelNode.State.Created)) {
            this.setState(ModelNode.State.ProjectionsDefined);
            this.resetPrivateData();
            for (ModelNodeInternal modelNodeInternal : this.dependents) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("resetting dependent node of {}: {}", (Object)this, (Object)modelNodeInternal);
                }
                modelNodeInternal.reset();
            }
            for (ModelNodeInternal modelNodeInternal : this.getLinks()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("resetting child node of {}: {}", (Object)this, (Object)modelNodeInternal);
                }
                modelNodeInternal.reset();
            }
        }
    }

    protected abstract void resetPrivateData();

    @Override
    public Optional<String> getValueDescription() {
        this.ensureUsable();
        return this.getAdapter().getValueDescription(this);
    }

    @Override
    public Optional<String> getTypeDescription() {
        this.ensureUsable();
        ModelView<Object> modelView = this.getAdapter().asImmutable(ModelType.untyped(), this, null);
        if (modelView != null) {
            ModelType<Object> type = modelView.getType();
            if (type != null) {
                return Optional.of((Object)type.toString());
            }
            modelView.close();
        }
        return Optional.absent();
    }

    @Override
    public List<ModelRuleDescriptor> getExecutedRules() {
        return this.executedRules;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

