/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.line.diff;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import de.regnis.q.sequence.line.QSequenceLineCache;
import de.regnis.q.sequence.line.diff.QDiffGenerator;
import de.regnis.q.sequence.line.diff.QDiffGeneratorFactory;
import de.regnis.q.sequence.line.diff.QDiffManager;
import de.regnis.q.sequence.line.diff.QDiffSequenceGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public final class QDiffNormalGenerator
extends QDiffSequenceGenerator
implements QDiffGeneratorFactory {
    public static final String TYPE = "normal";
    private Map myGeneratorsCache;

    public static void setup() {
        QDiffManager.registerDiffGeneratorFactory(new QDiffNormalGenerator(), TYPE);
    }

    private QDiffNormalGenerator(Map properties) {
        super(properties, null);
    }

    private QDiffNormalGenerator() {
        super(null, null);
    }

    public void generateDiffHeader(String item, String leftInfo, String rightInfo, Writer output) throws IOException {
        output.write("*** ");
        output.write(item);
        output.write(this.getEOL());
    }

    protected void processBlock(QSequenceDifferenceBlock[] segment, QSequenceLineCache sourceLines, QSequenceLineCache targetLines, String encoding, Writer output) throws IOException {
        for (int i = 0; i < segment.length; ++i) {
            QSequenceDifferenceBlock block = segment[i];
            this.processBlock(block.getLeftFrom(), block.getLeftTo(), sourceLines, block.getRightFrom(), block.getRightTo(), targetLines, encoding, output);
        }
    }

    protected void processBlock(QSequenceDifferenceBlock[] segment, QSequenceLineCache sourceLines, QSequenceLineCache targetLines, OutputStream output) throws IOException {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public QDiffGenerator createGenerator(Map properties) {
        QDiffGenerator generator;
        if (this.myGeneratorsCache == null) {
            this.myGeneratorsCache = new HashMap();
        }
        if ((generator = (QDiffGenerator)this.myGeneratorsCache.get(properties)) != null) {
            return generator;
        }
        generator = new QDiffNormalGenerator(properties);
        this.myGeneratorsCache.put(properties, generator);
        return generator;
    }

    protected void processBlock(int sourceStartLine, int sourceEndLine, QSequenceLineCache sourceLines, int targetStartLine, int targetEndLine, QSequenceLineCache targetLines, String encoding, Writer output) throws IOException {
        if (sourceStartLine > sourceEndLine) {
            this.add(sourceStartLine, targetStartLine, targetEndLine, targetLines, encoding, output);
        } else if (targetStartLine > targetEndLine) {
            this.delete(targetStartLine, sourceStartLine, sourceEndLine, sourceLines, encoding, output);
        } else {
            this.change(targetStartLine, targetEndLine, targetLines, sourceStartLine, sourceEndLine, sourceLines, encoding, output);
        }
    }

    protected String displayWhiteSpace(String s) {
        if (Boolean.TRUE.toString().equals(this.getProperties().get("whitespace"))) {
            s = s.replaceAll("\t", "<tb>");
            s = s.replaceAll(" ", ".");
        }
        return s;
    }

    protected void delete(int deleteAt, int deleteStart, int deleteEnd, QSequenceLineCache deleteLines, String encoding, Writer output) throws IOException {
        int displayStart = deleteStart + 1;
        int displayEnd = deleteEnd + 1;
        int displayAt = deleteAt + 1;
        this.println(displayStart + (displayEnd != displayStart ? "," + displayEnd : "") + "d" + displayAt, output);
        int delLine = deleteStart;
        while (delLine <= deleteEnd) {
            this.print("<" + this.displayWhiteSpace(this.printLine(deleteLines.getLine(delLine++), encoding)), output);
        }
    }

    protected void add(int addAt, int addStart, int addEnd, QSequenceLineCache addLines, String encoding, Writer output) throws IOException {
        int displayStart = addStart + 1;
        int displayEnd = addEnd + 1;
        int displayAt = addAt + 1;
        this.println(displayAt + "a" + displayStart + (displayEnd != displayStart ? "," + displayEnd : ""), output);
        int addLine = addStart;
        while (addLine <= addEnd) {
            this.print(">" + this.displayWhiteSpace(this.printLine(addLines.getLine(addLine++), encoding)), output);
        }
    }

    protected void change(int replaceStart, int replaceEnd, QSequenceLineCache replaceLines, int replaceWithStart, int replaceWithEnd, QSequenceLineCache replaceWithLines, String encoding, Writer output) throws IOException {
        int displayStart = replaceStart + 1;
        int displayEnd = replaceEnd + 1;
        int displayWithStart = replaceWithStart + 1;
        int displayWithEnd = replaceWithEnd + 1;
        this.println(displayStart + (displayEnd != displayStart ? "," + displayEnd : "") + "c" + displayWithStart + (displayWithEnd != displayWithStart ? "," + displayWithEnd : ""), output);
        int replaceLine = replaceStart;
        while (replaceLine <= replaceEnd) {
            this.print("<" + this.displayWhiteSpace(this.printLine(replaceLines.getLine(replaceLine++), encoding)), output);
        }
        this.println("---", output);
        int replaceWithLine = replaceWithStart;
        while (replaceWithLine <= replaceWithEnd) {
            this.print(">" + this.displayWhiteSpace(this.printLine(replaceWithLines.getLine(replaceWithLine++), encoding)), output);
        }
    }
}

